% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aceEditor.R
\name{aceEditor}
\alias{aceEditor}
\title{Ace editor}
\usage{
aceEditor(
  contents,
  mode = NULL,
  theme = NULL,
  fontSize = 14,
  tabSize = NULL,
  autoCompletion = TRUE,
  snippets = FALSE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{contents}{this can be the path to a file, \code{NULL} to open an
empty editor, or missing to open the file currently open in RStudio}

\item{mode}{the language of the contents; if \code{NULL} and the contents are
read from a file, the mode is guessed from the extension of the file;
run \code{\link{getAceModes}} to get the list of available modes}

\item{theme}{the theme of the editor; if \code{NULL}, the theme is set to the
theme currently used in RStudio; run \code{\link{getAceThemes}} to get
the list of available themes}

\item{fontSize}{font size}

\item{tabSize}{number of spaces for the indentation (usually \code{2} or
\code{4}); if \code{NULL}, it is set to the one used in RStudio}

\item{autoCompletion}{logical, whether to enable the auto completion}

\item{snippets}{logical, whether to enable the snippets (for example, there
is a snippet for \code{switch} in JavaScript)}

\item{width, height}{dimensions; the default values are nice for usage in
the RStudio viewer pane}

\item{elementId}{a HTML id for the container; this is useless for common
usage}
}
\description{
Open the Ace editor.
}
\examples{
# in RStudio, `aceEditor()` opens the current file:
aceEditor()

# opens a new JavaScript file:
aceEditor(NULL, mode = "javascript")

# opens an existing file:
aceEditor(system.file("htmlwidgets", "aceEditor.css", package = "aceEditor"))


# two editors side-by-side:
library(aceEditor)
library(htmltools)

ed1 <- aceEditor(
  width = "100\%", height = "calc(100vh - 10px)"
)
ed2 <- aceEditor(
  width = "100\%", height = "calc(100vh - 10px)"
)

if(interactive()){
  browsable(
    div(
      div(ed1, style="position: fixed; left: 1vw; right: 51vw;"),
      div(ed2, style="position: fixed; left: 51vw; right: 1vw;")
    )
  )
}


# two stacked editors:
library(aceEditor)
library(htmltools)

ed1 <- aceEditor(
  height = "calc(50vh - 10px)", width = "100\%"
)
ed2 <- aceEditor(
  height = "calc(50vh - 10px)", width = "100\%"
)

if(interactive()){
  browsable(
    tagList(
      tags$style(HTML(
        ".editor {",
        "  position: fixed;",
        "  left: 1vw;",
        "  width: 98vw;",
        "}"
      )),
      div(
        div(ed1, class = "editor", style = "bottom: calc(50vh - 25px);"),
        div(ed2, class = "editor", style = "top: calc(50vh);")
      )
    )
  )
}
}
