% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_rounding.R
\name{acled_rounding}
\alias{acled_rounding}
\title{Rounding function}
\usage{
acled_rounding(num, digits = 0)
}
\arguments{
\item{num}{int. This is the number we are trying to round.}

\item{digits}{int. Where do we want to round up. It accepts 0 (whole number), 1 (tenth place), 2 (hundredths), etc.}
}
\value{
A rounded numeric value
}
\description{
This function addresses some of the conflicts of rounding in R, especially when trying to round up.
}
\details{
This function is meant to address the problem of rounding in R where the approach is always round to even. The function is meant to round things following the simple rule. If the decimal is 5+ then round up, if not round down. With the 'digits' argument, one can set up the specificity of the rounding, 0= whole number, 1 = tenth place, 2=hundreds place, and so on.
}
\examples{
x1 <- 1.569
x2 <- 104.530
x3 <- 54.430
x4 <- 205.49999
acled_rounding(x1)
acled_rounding(x2)
acled_rounding(x3)
acled_rounding(x4)
}
\concept{Helpers}
