% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_cuts_srt.R
\name{search_cuts_srt}
\alias{search_cuts_srt}
\title{Create srt subtitles for all search results}
\usage{
search_cuts_srt(
  x,
  s,
  outputFolder = NULL,
  speaker.show = TRUE,
  speaker.width = 3,
  speaker.ending = ":"
)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{outputFolder}{Character string; if parameter is not set, the srt subtitles will only be inserted in \code{s@results}; if the path to a existing folder is given transcripts will be saved in '.srt' format.}

\item{speaker.show}{Logical; if \code{TRUE} name of speaker will be shown before the content of the annotation.}

\item{speaker.width}{Integer; width of speaker abbreviation, -1 for full name without shortening.}

\item{speaker.ending}{Character string; string that is added at the end of the speaker name.}
}
\value{
Search object;
}
\description{
Subtitles in 'Subrib Title' .srt format will be created for each search result.
The subtitles will be inserted into the column defined in \code{s@cuts.column.srt}.
}
\details{
\emph{Span} \cr
If you want to extend the cut before or after each search result, you can modify \code{@cuts.span.beforesec} and \code{@cuts.span.aftersec} in your search object.
If you want to modify the layout of the print transcripts, create a new layout object with \code{mylayout <- methods::new("layout")}, modify the settings and pass it as argument \code{l}.
}
\examples{
library(act)

# Search
mysearch <- act::search_new(examplecorpus, pattern="yo")

# Create srt subtitles for all search results
test <- act::search_cuts_srt (x=examplecorpus, s=mysearch)

# Display srt subtitle of first three results
cat(test@results[1,mysearch@cuts.column.srt])

# Create srt subtitle including 1 sec before and 5 sec after
mysearch@cuts.span.beforesec = 1
mysearch@cuts.span.aftersec = 5
test <- act::search_cuts_srt (x=examplecorpus,
								s=mysearch)

# Display srt subtitle of first  results
cat(test@results[1,mysearch@cuts.column.srt])
}
