% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_data}
\alias{plot_data}
\title{Plot accelerometer data for each day}
\usage{
plot_data(
  data,
  metric = "axis1",
  col_time = "time",
  col_nonwear = "non_wearing_count",
  col_wear = "wearing_count"
)
}
\arguments{
\item{data}{A dataframe obtained using the \code{\link{prepare_dataset}} and then the \code{\link{mark_wear_time}} functions.}

\item{metric}{A character value to indicate the name of the variable to be plotted against time.}

\item{col_time}{A character value to indicate the name of the variable to plot time data.}

\item{col_nonwear}{A character value to indicate the name of the variable used to count nonwear time.}

\item{col_wear}{A character value to indicate the name of the variable used to count wear time.}
}
\value{
A \code{ggplot} object.
}
\description{
This function plots accelerometer data against time for each day of measurement,
with the possibility to specify the metric to visualize.
}
\examples{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    to_epoch = 60,
    cts  = "vm",
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
plot_data(
    data = mydata_with_wear_marks, 
    metric = "vm", 
    col_time = "time", 
    col_nonwear = "non_wearing_count", 
    col_wear = "wearing_count"
    )

}
