% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_wear_time.R
\name{mark_wear_time}
\alias{mark_wear_time}
\title{Mark dataset for nonwear/wear time}
\usage{
mark_wear_time(
  dataset,
  TS = "TimeStamp",
  to_epoch = 60,
  cts = "vm",
  frame = 90,
  allowanceFrame = 2,
  streamFrame = 30
)
}
\arguments{
\item{dataset}{A dataframe obtained using the \code{\link{prepare_dataset}} function.}

\item{TS}{A character value indicating the name of the variable where date and time information are provided.}

\item{to_epoch}{A numeric value indicating the length of the epoch to use (in seconds) for accumulating data. The value must be superior or equal to the recording epoch that was used for the measurement.}

\item{cts}{A character value indicating the name of the variable used by the nonwear/wear detection algorithm.}

\item{frame}{A numeric value for the length of the time window (in minutes) used to detect nonwear/wear time.}

\item{allowanceFrame}{A numeric value for the length of the time window (in minutes) with nonzero counts allowed
within the detected nonwear period.}

\item{streamFrame}{A numeric value for the length of the time window required around the detected activity
to validate nonwear time.}
}
\value{
A dataframe.
}
\description{
This function wraps the \code{\link[PhysicalActivity]{dataCollapser}} and the
\code{\link[PhysicalActivity]{wearingMarking}} functions from the \code{PhysicalActivity} package.
After collapsing data, the function adds \code{time} and
\code{date} columns. Then, the function analyzes the dataset for nonwear time detection. Finally, the function
adds two variables to the dataset: the variable \code{non_wearing_count}
that contains the number 1 when the device was \emph{not} worn (otherwise, 0 is used),
and the variable \code{wearing_count} that contains the number 1 when the device
was worn (otherwise, 0 is used).
}
\examples{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    to_epoch = 60,
    cts  = "vm",
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
head(mydata_with_wear_marks)

}
