% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_agd.R
\name{read_agd_raw}
\alias{read_agd_raw}
\title{Read an *.agd file, with no post-processing}
\usage{
read_agd_raw(file, tz = "UTC")
}
\arguments{
\item{file}{Full path to an agd file to read.}

\item{tz}{Time zone to convert DateTime ticks to POSIX time.}
}
\value{
A list of five tables: settings, data, filters, sleep,
awakenings and, if available, capsense.
}
\description{
Read ActiGraph sleep watch data from an SQLite database stored in an
AGD file and return a list with (at least) five tables: data, sleep,
filters, settings, awakenings. The tables have the schema described
in the ActiLife 6 User manual and the timestamps are converted from
Unix time format to human-readable POSIXct representation.
Code is from actigraph.sleepr package \url{https://github.com/dipetkov/actigraph.sleepr/}.
See LICENCE.note file in the app skeleton.
}
\details{
Some ActiGraph devices contain a capacitive sensor to detect
monitor removal when worn against the skin. If that data is
available, the return list includes a capsense table as well.
}
\examples{
file <- system.file("extdata", "acc.agd",
  package = "activAnalyzer"
)
str(read_agd_raw(file))

}
\references{
ActiLife 6 User's Manual by the ActiGraph Software
Department. 04/03/2012.

\code{covertagd}: R package for converting agd files
from ActiGraph into data.frames.
}
\seealso{
\code{\link[=read_agd]{read_agd()}}
}
