% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_intensity_distri_metrics.R
\name{compute_intensity_distri_metrics}
\alias{compute_intensity_distri_metrics}
\title{Compute intensity distribution metrics}
\usage{
compute_intensity_distri_metrics(
  data,
  col_axis = "vm",
  col_time = "time",
  valid_wear_time_start = "00:00:00",
  valid_wear_time_end = "23:59:59",
  start_first_bin = 0,
  start_last_bin = 10000,
  bin_width = 500
)
}
\arguments{
\item{data}{A dataframe obtained using the \code{\link{prepare_dataset}}, \code{\link{mark_wear_time}}, and then the \code{\link{mark_intensity}} functions.}

\item{col_axis}{A character value to indicate the name of the variable to be used to compute total time per bin of intensity.}

\item{col_time}{A character value to indicate the name of the variable to be used to determine the epoch length of the dataset.}

\item{valid_wear_time_start}{A character value with the HH:MM:SS format to set the start of the daily period that will be considered for computing metrics.}

\item{valid_wear_time_end}{A character value with the HH:MM:SS format to set the end of the daily period that will be considered for computing metrics.}

\item{start_first_bin}{A numeric value to set the lower bound of the first bin of the intensity band (in counts/epoch duration).}

\item{start_last_bin}{A numeric value to set the lower bound of the last bin of the intensity band (in counts/epoch duration).}

\item{bin_width}{A numeric value to set the width of the bins of the intensity band (in counts/epoch duration).}
}
\value{
A list of objects: \code{metrics}, \code{p_band}, and \code{p_log}. \code{metrics} is a dataframe containing
the intensity gradients and the MX metrics (in counts/epoch duration used) as described in Rowlands et al. (2018; doi:10.1249/MSS.0000000000001561).
The graphic \code{p_band} shows the distribution of time spent in the configured bins of intensity for each day of the dataset.
The graphic \code{p_log} shows, for each day, the relationship between the natural log of time spent in each bin with the natural
log of the middle values of the intensity bins.
}
\description{
This function computes metrics that describe the distribution of intensity for each day of a dataset. Computations are performed
based on the daily periods set for analysis and on the detected wear time.
}
\examples{
\donttest{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    to_epoch = 60,
    cts  = "vm",
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
mydata_with_intensity_marks <- mark_intensity(
    data = mydata_with_wear_marks, 
    col_axis = "vm", 
    equation = "Sasaki et al. (2011) [Adults]",
    sed_cutpoint = 200, 
    mpa_cutpoint = 2690, 
    vpa_cutpoint = 6167, 
    age = 32,
    weight = 67,
    sex = "male"
    )
compute_intensity_distri_metrics(
   data = mydata_with_intensity_marks,
   col_axis = "vm",
   col_time = "time",
   valid_wear_time_start = "00:00:00",
   valid_wear_time_end = "23:59:59",
   start_first_bin = 0,
   start_last_bin = 10000,
   bin_width = 500
    )
 }

}
