% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activeC.R
\name{C_var}
\alias{C_var}
\title{Element-wise Cn+1 variance}
\usage{
C_var(C, xnew, grad = FALSE)
}
\arguments{
\item{C}{A const_C object, the result of a call to \code{\link[activegp]{C_GP}}.}

\item{xnew}{The new design point}

\item{grad}{If \code{FALSE}, calculate variance of update. If \code{TRUE}, returns the gradient.}
}
\value{
A real number giving the expected elementwise variance of C given the current design.
}
\description{
Element-wise Cn+1 variance
}
\examples{
################################################################################
### Norm of the variance of C criterion landscape
################################################################################
library(hetGP)
set.seed(42)
nvar <- 2
n <- 20

# theta gives the subspace direction
f <- function(x, theta = pi/6, nugget = 1e-6){
 if(is.null(dim(x))) x <- matrix(x, 1)
 xact <- cos(theta) * x[,1] - sin(theta) * x[,2]
 return(hetGP::f1d(xact) 
   + rnorm(n = nrow(x), sd = rep(nugget, nrow(x))))
}

design <- matrix(signif(runif(nvar*n), 2), ncol = nvar)
response <- apply(design, 1, f)
model <- mleHomGP(design, response, lower = rep(1e-4, nvar),
                  upper = rep(0.5,nvar), known = list(g = 1e-4))
                  
C_hat <- C_GP(model)

ngrid <- 51
xgrid <- seq(0, 1,, ngrid)
Xgrid <- as.matrix(expand.grid(xgrid, xgrid))
filled.contour(matrix(f(Xgrid), ngrid))

cvar_crit <- function(C, xnew){
 return(sqrt(sum(C_var(C, xnew)^2)))
}

Cvar_grid <- apply(Xgrid, 1, cvar_crit, C = C_hat)
filled.contour(matrix(Cvar_grid, ngrid), color.palette = terrain.colors,
               plot.axes = {axis(1); axis(2); points(design, pch = 20)})
}
\references{
N. Wycoff, M. Binois, S. Wild (2019+), Sequential Learning of Active Subspaces, preprint.\cr
}
