% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REfunctions.R
\name{circplotREs}
\alias{circplotREs}
\title{Random Effects Circular Plot}
\usage{
circplotREs(
  model,
  RE1 = TRUE,
  RE2 = FALSE,
  axisunits = c("radians", "sun", "time", "solar", "none")
)
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function}

\item{RE1}{Logical vector for whether to plot GCMM activity curve with random intercepts from RE1; default=TRUE}

\item{RE2}{Logical vector for whether to plot GCMM activity curve with random intercepts from RE2; default=FALSE}

\item{axisunits}{Units for x axis, either "radians", "time", "solar", "sun", or "none"; default="radians"}
}
\value{
No return value; prints circle plot of GCMM random intercepts and 95\% HDI
}
\description{
Circular plot of GCMM random intercepts and 95\% HDI
}
\examples{
\donttest{ FoxGCMMREs<-GCMM(data=redfoxsample$Radians, RE1=redfoxsample$SamplingPeriod, 
       saveREs=TRUE, scale=c("2pi"), family="vonmises", autorun=FALSE,
       adapt=0, sample=300, burnin=300, thin=1)
    circplotREs(FoxGCMMREs, axisunits="sun") }
}
