% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareGCMM.R
\name{compareGCMM}
\alias{compareGCMM}
\title{Compare GCMM parameters or estimates}
\usage{
compareGCMM(model1, p1, model2 = "NULL", p2, sample = 1000, plot = TRUE)
}
\arguments{
\item{model1}{Object either of class \code{GCMM} with output from \code{\link{GCMM}} function or of class \code{GCMMestimate} with output from other activityGCMM functions}

\item{p1}{Name of first parameter to compare, from model1}

\item{model2}{Object of either class \code{GCMM}, \code{GCMMestimate}, or a vector or single value for which to compare with model 1; if left blank, it is assumed
that both parameters from arguments \code{p1} and \code{p2} are from model1}

\item{p2}{Second parameter to compare, either name of a parameter, estimate, or a vector of values}

\item{sample}{Number of posterior samples from which to build HDI; default=1000}

\item{plot}{Logical argument for whether to plot histograms of p1, p2, and the difference between them; default=TRUE}
}
\value{
Returns object of class \code{GCMMestimate} containing a list, including \code{PD} containing the posterior distributions of p1, p2 and the difference between them,
and summary information (HDIs and PDS)
}
\description{
Compare two posterior distributions of GCMM parameters or estimates
}
