% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cap.R
\name{Write.cap}
\alias{Write.cap}
\title{Write data and capture the file information within dependency object}
\usage{
Write.cap(obj = NULL, file.info, write.fcn, source_info, ...)
}
\arguments{
\item{obj}{object to write, if null then open graphics device}

\item{file.info}{file information list}

\item{write.fcn}{function to write file}

\item{source_info}{source information list}

\item{...}{arguments passed to write.fcn}
}
\value{
file.info file information returned
}
\description{
Write data and capture the file information within dependency object
}
\details{
Not usually direct use. See Write() and Graph().
}
\examples{
\dontrun{
source_info <- create_source_file_dir("adaprHome","tree_controller.R")
testfile <- file.path(source_info$results.dir,"test.csv")
fileinfo <- Create.file.info(dirname(testfile),basename(testfile),"cars dataset")
Write.cap(cars,fileinfo,write.csv,source_info,row.names=FALSE)
} 
}

