% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_funs.R
\name{prob_best}
\alias{prob_best}
\title{Calculate the probabilities of each arm being the best}
\usage{
prob_best(m, highest_is_best = FALSE)
}
\arguments{
\item{m}{a matrix with one column per trial arm (named as the \code{arms}) and one
row for each draw from the posterior distributions.}

\item{highest_is_best}{single logical, specifies whether larger estimates of
the outcome are favourable or not; defaults to \code{FALSE}, corresponding to,
e.g., an undesirable binary outcomes (e.g., mortality) or a continuous
outcome where lower numbers are preferred (e.g., hospital length of stay).}
}
\value{
A named numeric vector of probabilities (names corresponding to
\code{arms}).
}
\description{
Used internally. This function takes a \code{matrix} as calculated by the
\code{\link[=get_draws_binom]{get_draws_binom()}}, \code{\link[=get_draws_norm]{get_draws_norm()}} or a corresponding custom function
(as specified using the \code{fun_draws} argument in \code{\link[=setup_trial]{setup_trial()}}; see
\code{\link[=get_draws_generic]{get_draws_generic()}}) and calculates the probabilities of each arm being the
best (defined as either the highest or the lowest value, as specified by the
\code{highest_is_best} argument in \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or
\code{\link[=setup_trial_norm]{setup_trial_norm()}}).
}
\keyword{internal}
