% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_opt.R
\name{gp_opt}
\alias{gp_opt}
\title{Gaussian process-based optimisation}
\usage{
gp_opt(
  x,
  y,
  target,
  dir = 0,
  resolution = 5000,
  kappa = 1.96,
  pow = 1.95,
  lengthscale = 1,
  scale_x = TRUE,
  noisy = FALSE,
  narrow = FALSE
)
}
\arguments{
\item{x}{numeric vector, the previous values where the function being
calibrated was evaluated.}

\item{y}{numeric vector, the corresponding results of the previous
evaluations at the \code{x} values (must be of the same length as \code{x}).}

\item{target}{single numeric value, the desired target value for the
calibration process.}

\item{dir}{single numeric value (default \code{0}), used when selecting the next
value to evaluate at. See \code{\link[=which_nearest]{which_nearest()}} for further description.}

\item{resolution}{single integer (default \code{5000}), size of the grid at which
the predictions used to select the next value to evaluate at are made.\cr
\strong{Note:} memory use and time will substantially increase with higher
values.}

\item{kappa}{single numeric value \verb{> 0} (default \code{1.96}), used for the width
of uncertainty bounds (based on the Gaussian process posterior predictive
distribution), which are used to select the next value to evaluate at.}

\item{pow}{single numerical value, passed to \code{\link[=cov_mat]{cov_mat()}} and controls the
smoothness of the Gaussian process. Should be between \code{1} (no smoothness,
piecewise straight lines between each subsequent \code{x}/\code{y}-coordinate if
\code{lengthscale} described below is \code{1}) and \code{2}; defaults to \code{1.95}, which
leads to slightly faster decay of correlations when \code{x} values are
internally scaled to the \verb{[0, 1]}-range compared to \code{2}.}

\item{lengthscale}{single numerical value (default \code{1}) or numerical vector
of length \code{2}; all values must be finite and non-negative. If a single
value is provided, this will be used as the \code{lengthscale} hyperparameter
and passed directly to \code{\link[=cov_mat]{cov_mat()}}. If a numerical vector of length \code{2} is
provided, the second value must be higher than the first and the optimal
\code{lengthscale} in this range will be found using an optimisation algorithm.
If any value is \code{0}, a minimum amount of noise will be added as
lengthscales must be \verb{> 0}. Controls smoothness/decay in combination
with \code{pow}.}

\item{scale_x}{single logical value; if \code{TRUE} (the default) the \code{x}-values
will be scaled to the \verb{[0, 1]} range according to the minimum/maximum
values provided. If \code{FALSE}, the model will use the original scale. If
distances on the original scale are small, scaling may be preferred. The
returned values will always be on the original scale.}

\item{noisy}{single logical value. If \code{FALSE} (the default), a noiseless
process is assumed, and interpolation between values is performed (i.e.,
with no uncertainty at the evaluated \code{x}-values); if \code{TRUE}, the \code{y}-values
are assumed to come from a noisy process, and regression is performed
(i.e., some uncertainty at the evaluated \code{x}-values will be included in the
predictions, with the amount estimated using an optimisation algorithm).}

\item{narrow}{single logical value. If \code{FALSE} (the default), predictions are
evenly spread over the full \code{x}-range. If \code{TRUE}, the prediction grid will
be spread evenly over an interval consisting of the two \code{x}-values with
corresponding \code{y}-values closest to the target in opposite directions. This
setting should only be used if \code{noisy} is \code{FALSE} and only if the function
can safely be assumed to be only monotonically increasing or decreasing, in
which case this will lead to a faster search and a smoother prediction grid
in the relevant region without increasing memory use.}
}
\value{
List containing two elements, \code{next_x}, a single numerical value, the
suggested next \code{x} value at which to evaluate the function, and
\code{predictions}, a \code{data.frame} with \code{resolution} rows and the four columns:
\code{x}, the \code{x} grid values where predictions are made; \code{y_hat}, the predicted
means, and \code{lub} and \code{uub}, the lower and upper uncertainty bounds of the
predictions according to \code{kappa}.
}
\description{
Used internally. Simple Gaussian process-based Bayesian optimisation
function, used to find the next value to evaluate (as \code{x}) in the
\code{\link[=calibrate_trial]{calibrate_trial()}} function. Uses only a single input dimension, which may
be rescaled to the \verb{[0, 1]} range by the function, and a covariance structure
based on absolute distances between values, raised to a power (\code{pow}) and
subsequently divided by \code{lengthscale} before the inverse exponentiation of
the resulting matrix is used. The \code{pow} and \code{lengthscale} hyperparameters
consequently control the smoothness by controlling the rate of decay between
correlations with distance.\cr
The optimisation algorithm uses bi-directional uncertainty bounds in an
acquisition function that suggests the next target to evaluate, with wider
uncertainty bounds (higher \code{kappa}) leading to increased 'exploration' (i.e.,
the function is more prone to suggest new target values where the uncertainty
is high and often further from the best evaluation so far) and narrower
uncertainty bounds leading to increased 'exploitation' (i.e., the function is
more prone to suggest new target values relatively close to the mean
predictions from the model).\cr
The \code{dir} argument controls whether the suggested value (based on both
uncertainty bounds) should be the value closest to \code{target} in either
direction (\code{dir = 0}), at or above \code{target} (\code{dir > 0}), or at or below
target (\code{dir < 0}), if any, are preferred.\cr
When the function being evaluated is noise-free and monotonically increasing
or decreasing, the optimisation function can narrow the range of predictions
based on the input evaluations (\code{narrow = TRUE}), leading to a finer grid of
potential new targets to suggest compared to when predictions are spaced over
the full range.\cr
If the new value at which to evaluate the function suggested has already been
evaluated, random noise will be added to ensure evaluation at a new value
(if \code{narrow} is \code{FALSE}, noise will be based on a random draw from a normal
distribution with the current suggested value as mean and the standard
deviation of the \code{x} values as SD, truncated to the range of \code{x}-values; if
\code{narrow} is \code{TRUE}, a new value drawn from a uniform distribution within the
current narrowed range will be suggested. For both strategies, the process
will be repeated until the suggested value is 'new').
\cr The Gaussian process model used is partially based on code from Gramacy
2020 (with permission), see \strong{References}.
}
\references{
Gramacy RB (2020). Chapter 5: Gaussian Process Regression. In: Surrogates:
Gaussian Process Modeling, Design and Optimization for the Applied Sciences.
Chapman Hall/CRC, Boca Raton, Florida, USA.
\href{https://bookdown.org/rbg/surrogates/chap5.html}{Available online}.

Greenhill S, Rana S, Gupta S, Vellanki P, Venkatesh S (2020). Bayesian
Optimization for Adaptive Experimental Design: A Review. IEEE Access, 8,
13937-13948. \doi{10.1109/ACCESS.2020.2966228}
}
\keyword{internal}
