% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{adbc_xptr_move}
\alias{adbc_xptr_move}
\alias{adbc_xptr_is_valid}
\title{Low-level pointer details}
\usage{
adbc_xptr_move(x, check_child_count = TRUE)

adbc_xptr_is_valid(x)
}
\arguments{
\item{x}{An 'adbc_database', 'adbc_connection', 'adbc_statement', or
'nanoarrow_array_stream'}

\item{check_child_count}{Ensures that \code{x} has a zero child count before
performing the move. This should almost always be \code{TRUE}.}
}
\value{
\itemize{
\item \code{adbc_xptr_move()}: A freshly-allocated R object identical to \code{x}
\item \code{adbc_xptr_is_valid()}: Returns FALSE if the ADBC object pointed to by \code{x}
has been invalidated.
}
}
\description{
\itemize{
\item \code{adbc_xptr_move()} allocates a fresh R object and moves all values pointed
to by \code{x} into it. The original R object is invalidated by zeroing its
content. This is useful when returning from a function where
\link[=with_adbc]{lifecycle helpers} were used to manage the original
object.
\item \code{adbc_xptr_is_valid()} provides a means by which to test for an invalidated
pointer.
}
}
\examples{
db <- adbc_database_init(adbc_driver_void())
adbc_xptr_is_valid(db)
db_new <- adbc_xptr_move(db)
adbc_xptr_is_valid(db)
adbc_xptr_is_valid(db_new)

}
