% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea_stepwise.R
\name{adea_stepwise}
\alias{adea_stepwise}
\title{Select an optimal subset of variables for DEA analysis}
\usage{
adea_stepwise(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  name = "",
  direction = c("backward", "backward/input", "backward/output"),
  load.critical = 0.5,
  max.steps = ncol(input) + ncol(output) - 2,
  verbose = 0
)
}
\arguments{
\item{input}{A matrix or a data frame with the inputs of units to be evaluated, one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame with the outputs of units to be evaluated, one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or use "output" for output orientation in DEA model.}

\item{load.orientation}{It allows the selection of variables to be included in load analysis.
Its default value is "inoutput" which means that all input and all output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{name}{An optional descriptive name for the model. It will be shown in print and summary results.}

\item{direction}{The direction in which the variables go in and out of the model. Until now, only backward option is implemented.}

\item{load.critical}{Minimum values for load.ratios to consider that a variable should be considered in the model. It can be also a vector with two values, the first value input loads and the second for output loads.}

\item{max.steps}{The maximum number of steps allowed.}

\item{verbose}{Use 0 for minimal output, only final model. 1 or more to get detailed information of each step. This option affects only to printed output but not the result.}
}
\value{
The function returns a DEA model with optimised set of variables.
}
\description{
Stepwise procedure for variable selection in DEA models.
This is a back end function for adea_hierarchical and adea_parametric functions.
So, it is not for end user use.
}
