% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_fsdea.R
\name{build_fsdea}
\alias{build_fsdea}
\title{Build fsdea problem}
\usage{
build_fsdea(
  input,
  output,
  orientation = c("input", "output"),
  ninputs,
  noutputs,
  nvariables,
  lp = NULL
)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{ninputs}{a number which is the number input features, variables, to be selected. Its default value is the number of input variables.}

\item{noutputs}{a number which is the number output features, variables, to be selected. Its default value is the number of output variables.}

\item{nvariables}{a number of total features, variables, to be selected. Only if both ninputs and noutputs are omitted. In other case it is ignored.}
}
\value{
lp
}
\description{
For the given input and output build the feature selection problem and return it.
}
\details{
This function implement the feature selection method in the article [Benitez-Pena, S., Bogetoft, P. and Romero Morales, D. *Feature Selection in Data Envelopment Analysis: A Mathematical Optimization approach* Omega, Elsevier BV, **2020**, Vol. 96, pp. 102068](http://www.sciencedirect.com/science/article/pii/S0305048318312131)

Note: As this function is mainly for internal use, to avoid unnecessary overload, it does not do an extensive check of the input parameters. Use the higher level fsdea function instead.
}
\keyword{internal}
