% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.standardize}
\alias{matrix.standardize}
\title{Creates a standardized matrix.}
\usage{
matrix.standardize(mat, centers = NULL, scales = NULL, ddof = 0, n_threads = 1)
}
\arguments{
\item{mat}{The underlying matrix.}

\item{centers}{The center values.}

\item{scales}{The scale values.}

\item{ddof}{Degrees of freedom.}

\item{n_threads}{Number of threads.}
}
\value{
Standardized matrix.
}
\description{
Creates a standardized matrix.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), n, p)
out <- matrix.standardize(matrix.dense(X))
}
