% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.subset}
\alias{matrix.subset}
\title{Creates a subset of the matrix along an axis.}
\usage{
matrix.subset(mat, indices, axis = 0, n_threads = 1)
}
\arguments{
\item{mat}{The matrix to subset.}

\item{indices}{Array of indices to subset the matrix.}

\item{axis}{The axis along which to subset.}

\item{n_threads}{Number of threads.}
}
\value{
Subset of the matrix along an axis.
}
\description{
Creates a subset of the matrix along an axis.
}
\examples{
n <- 100
p <- 20
X <- matrix.dense(matrix(rnorm(n * p), n, p))
indices <- c(1, 3, 10)
out <- matrix.subset(X, indices, axis=0)
out <- matrix.subset(X, indices, axis=1)
}
