% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.eager_cov}
\alias{matrix.eager_cov}
\title{Creates an eager covariance matrix.}
\usage{
matrix.eager_cov(mat, n_threads = 1)
}
\arguments{
\item{mat}{A dense matrix to be used with the \code{gaussian_cov()} solver.}

\item{n_threads}{Number of threads.}
}
\value{
The dense covariance matrix. This matrix is exactly \code{t(mat)\%*\%mat}, computed with some efficiency.
}
\description{
Creates an eager covariance matrix.
}
\examples{
n <- 100
p <- 20
mat <- matrix(rnorm(n * p), n, p)
out <- matrix.eager_cov(mat)
}
