% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.kronecker_eye}
\alias{matrix.kronecker_eye}
\title{Creates a Kronecker product with an identity matrix.}
\usage{
matrix.kronecker_eye(mat, K = 1, n_threads = 1)
}
\arguments{
\item{mat}{The matrix to view as a Kronecker product.}

\item{K}{Dimension of the identity matrix (default is 1, which does essentially nothing).}

\item{n_threads}{Number of threads.}
}
\value{
Kronecker product with identity matrix. If \code{mat} is n x p, the the resulting matrix will be nK x np.
The object is an S4 class with methods for efficient computation by adelie.
}
\description{
Creates a Kronecker product with an identity matrix.
}
\examples{
n <- 100
p <- 20
K <- 2
mat <- matrix(rnorm(n * p), n, p)
out <- matrix.kronecker_eye(mat, K)
mat <- matrix.dense(mat)
out <- matrix.kronecker_eye(mat, K)
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
