% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glintnet.R
\name{cv.glintnet}
\alias{cv.glintnet}
\title{Cross-validation for glintnet}
\usage{
cv.glintnet(
  X,
  glm,
  offsets = NULL,
  intr_keys = NULL,
  intr_values,
  levels = NULL,
  n_folds = 10,
  foldid = NULL,
  n_threads = 1,
  ...
)
}
\arguments{
\item{X}{Feature matrix. Either a regular R matrix, or else an
\code{adelie} custom matrix class, or a concatination of such.}

\item{glm}{GLM family/response object. This is an expression that
represents the family, the reponse and other arguments such as
weights, if present. The choices are \code{glm.gaussian()},
\code{glm.binomial()}, \code{glm.poisson()},
\code{glm.multinomial()}, \code{glm.cox()}, \code{glm.multinomial()},
and \code{glm.multigaussian()}. This is a required argument, and
there is no default. In the simple example below, we use \code{glm.gaussian(y)}.}

\item{offsets}{Offsets, default is \code{NULL}. If present, this is
a fixed vector or matrix corresponding to the shape of the natural
parameter, and is added to the fit.}

\item{intr_keys}{List of feature indices. This is a list of all features with which interactions can be
formed. Default is \code{1:p} where \code{p} is the number of columns in \code{X}.}

\item{intr_values}{List of integer vectors of feature indices. For each of the \code{m <= p} indices
listed in \code{intr_keys}, there is a vector of indices indicating which columns are candidates for
interaction with that feature. If a vector is \code{NULL}, that means all other features are candidates
for interactions.  The default is a list of length \code{m} where each element is \code{NULL};
that is \code{rep(list(NULL), m}.}

\item{levels}{Number of levels for each of the columns of \code{mat}, with \code{1} representing a
quantitative feature. A factor with \code{K} levels should be represented by the numbers \code{0,1,...,K-1}.}

\item{n_folds}{(default 10). Although \code{n_folds} can be
as large as the sample size (leave-one-out CV), it is not recommended for
large datasets. Smallest value allowable is \code{n_folds=3}.}

\item{foldid}{An optional vector of values between 1 and \code{n_folds}
identifying what fold each observation is in. If supplied, \code{n_folds} can
be missing.}

\item{n_threads}{Number of threads, default \code{1}.}

\item{...}{Additional named arguments to \code{grpnet}.}
}
\value{
A list of class \code{"glintnet"}, which inherits from class \code{"grpnet"}.
This has a a few additional components such as \code{pairs}, \code{groups} and \code{levels}.
Users typically use methods like \code{predict()}, \code{print()}, \code{plot()} etc to examine the object.
}
\description{
Does k-fold cross-validation for glintnet
}
\details{
The function runs \code{glintnet} \code{n_folds}+1 times; the first to get the
\code{lambda} sequence, and then the remainder to compute the fit with each
of the folds omitted. The out-of-fold deviance is accumulated, and the average deviance and
standard deviation over the folds is computed.  Note that \code{cv.glintnet}
does NOT search for values for \code{alpha}. A specific value should be
supplied, else \code{alpha=1} is assumed by default. If users would like to
cross-validate \code{alpha} as well, they should call \code{cv.glintnet} with
a pre-computed vector \code{foldid}, and then use this same \code{foldid} vector in
separate calls to \code{cv.glintnet} with different values of \code{alpha}.
Note also that the results of \code{cv.glintnet} are random, since the folds
are selected at random. Users can reduce this randomness by running
\code{cv.glintnet} many times, and averaging the error curves.
}
\examples{
set.seed(0)
n=500
d_cont = 5     # number of continuous features
d_disc = 5     # number of categorical features
Z_cont = matrix(rnorm(n*d_cont), n, d_cont)
levels = sample(2:5,d_disc, replace = TRUE)
Z_disc = matrix(0,n,d_disc)
for(i in seq(d_disc))Z_disc[,i] = sample(0:(levels[i]-1),n,replace=TRUE)
Z = cbind(Z_cont,Z_disc)
levels = c(rep(1,d_cont),levels)

xmat = model.matrix(~Z_cont[,1]*factor(Z_disc[,2]))
nc=ncol(xmat)
beta = rnorm(nc)
y = xmat\%*\%beta+rnorm(n)*1.5

cvfit <- cv.glintnet(Z, glm.gaussian(y), levels=levels, intr_keys = 1)
plot(cvfit)
predict(cvfit, newx=Z[1:5,])

}
\references{
Lim, Michael and Hastie, Trevor (2015) \emph{Learning interactions via hierarchical group-lasso regularization}, JCGS
\doi{10.1080/10618600.2014.938812}\cr
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.\cr
Friedman, J., Hastie, T. and Tibshirani, R. (2008)
\emph{Regularization Paths for Generalized Linear Models via Coordinate
Descent (2010), Journal of Statistical Software, Vol. 33(1), 1-22},
\doi{10.18637/jss.v033.i01}.\cr
Simon, N., Friedman, J., Hastie, T. and Tibshirani, R. (2011)
\emph{Regularization Paths for Cox's Proportional
Hazards Model via Coordinate Descent, Journal of Statistical Software, Vol.
39(5), 1-13},
\doi{10.18637/jss.v039.i05}.\cr
Tibshirani,Robert, Bien, J., Friedman, J., Hastie, T.,Simon, N.,Taylor, J. and
Tibshirani, Ryan. (2012) \emph{Strong Rules for Discarding Predictors in
Lasso-type Problems, JRSSB, Vol. 74(2), 245-266},
\url{https://arxiv.org/abs/1011.2234}.\cr
}
\seealso{
\code{cv.glintnet}, \code{predict.glintnet}, \code{plot.glintnet}, \code{print.glintnet}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie
\email{hastie@stanford.edu}
}
