% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\docType{class}
\name{PValue-class}
\alias{PValue-class}
\alias{PValue}
\alias{LinearShiftRepeatedPValue}
\alias{MLEOrderingPValue}
\alias{LikelihoodRatioOrderingPValue}
\alias{ScoreTestOrderingPValue}
\alias{StagewiseCombinationFunctionOrderingPValue}
\alias{NeymanPearsonOrderingPValue}
\title{P-values}
\usage{
PValue(g1, g2, label)

LinearShiftRepeatedPValue(wc1f = 0, wc1e = 1/2, wc2 = 1/2)

MLEOrderingPValue()

LikelihoodRatioOrderingPValue()

ScoreTestOrderingPValue()

StagewiseCombinationFunctionOrderingPValue()

NeymanPearsonOrderingPValue(mu0 = 0, mu1 = 0.4)
}
\arguments{
\item{g1}{functional representation of the p-value in the early futility and efficacy regions.}

\item{g2}{functional representation of the p-value in the continuation region.}

\item{label}{name of the p-value. Used in printing methods.}

\item{wc1f}{slope of futility boundary change.}

\item{wc1e}{slope of efficacy boundary change.}

\item{wc2}{slope of c2 boundary change.}

\item{mu0}{expected value of the normal distribution under the null hypothesis.}

\item{mu1}{expected value of the normal distribution under the null hypothesis.}
}
\value{
an object of class \code{PValue}. This class signals that an
object can be supplied to the \code{\link{analyze}} function.
}
\description{
This is the parent class for all p-values implemented in this package.
Details about the methods for calculating p-values can be found in
(our upcoming paper).
}
\details{
The implemented p-values are:
\itemize{
\item \code{MLEOrderingPValue()}
\item \code{LikelihoodRatioOrderingPValue()}
\item \code{ScoreTestOrderingPValue()}
\item \code{StagewiseCombinationFunctionOrderingPValue()}
}

The p-values are calculated by specifying an ordering of the sample space
calculating the probability that a random sample under the null hypothesis is
larger than the observed sample.
Some of the implemented orderings are based on the work presented in
\insertCite{emerson1990parameter}{adestr},
\insertCite{@Sections 8.4 in @jennison1999group}{adestr},
and \insertCite{@Sections 4.1.1 and 8.2.1 in @wassmer2016group}{adestr}.
}
\examples{
# This is the definition of a 'naive' p-value based on a Z-test for a one-armed trial
PValue(
  g1 = \(smean1, n1, sigma, ...) pnorm(smean1*sqrt(n1)/sigma, lower.tail=FALSE),
  g2 = \(smean1, smean2, n1, n2, ...) pnorm((n1 * smean1 + n2 * smean2)/(n1 + n2) *
                                        sqrt(n1+n2)/sigma, lower.tail=FALSE),
  label="My custom p-value")
}
\references{
\insertAllCited{}
}
\seealso{
\link{plot_p}
}
