% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entry_info.R
\name{adf_entry_name<-}
\alias{adf_entry_name<-}
\alias{adf_entry_name}
\alias{adf_entry_name<-.adf_file_con}
\alias{adf_entry_name<-.adf_device}
\alias{adf_entry_name<-.virtual_path}
\alias{adf_entry_name<-.adf_device.character}
\alias{adf_entry_name<-.adf_device.virtual_path}
\title{Obtain or modify an entry name on a virtual device}
\usage{
adf_entry_name(x, path, ...) <- value

adf_entry_name(x, path, ...)

\method{adf_entry_name}{adf_file_con}(x, path, ...) <- value

\method{adf_entry_name}{adf_device}(x, path, ...) <- value

\method{adf_entry_name}{virtual_path}(x, path, ...) <- value

\method{adf_entry_name}{adf_device.character}(x, path, ...) <- value

\method{adf_entry_name}{adf_device.virtual_path}(x, path, ...) <- value
}
\arguments{
\item{x}{Either a virtual device or virtual path.}

\item{path}{A \code{\link[=virtual_path]{virtual_path()}} pointing to the targeted entry (file or directory). Should
be omitted when \code{x} is already a virtual path.}

\item{...}{Ignored}

\item{value}{New name for the entry. The name will be sanitised and truncated before
it is assigned to the entry.}
}
\value{
Returns the entry name of the requested path or in case of an assign
operation (\verb{<-}) an updated version of \code{x}.
}
\description{
Get the name of an entry (root, file or directory) or update it with the
assign operator (\verb{<-}).
}
\examples{
## Open virtual device to demonstrate methods
my_device <- demo_adf(write_protected = FALSE)

## rename a specific entry
adf_entry_name(my_device, "DF0:mods/mod.intro") <- "mod.music"

## rename disk (also possible with `volume_name<-()`)
adf_entry_name(my_device, "DF0:") <- "my_disk"

close(my_device)
}
\author{
Pepijn de Vries
}
