% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_unit}
\alias{assert_unit}
\title{Asserts That a Parameter is Provided in the Expected Unit}
\usage{
assert_unit(dataset, param, required_unit, get_unit_expr)
}
\arguments{
\item{dataset}{A \code{data.frame}}

\item{param}{Parameter code of the parameter to check}

\item{required_unit}{Expected unit}

\item{get_unit_expr}{Expression used to provide the unit of \code{param}}
}
\value{
The function throws an error if the unit variable differs from the
unit for any observation of the parameter in the input dataset. Otherwise, the
dataset is returned invisibly.
}
\description{
Checks if a parameter (\code{PARAMCD}) in a dataset is provided in the expected
unit.
}
\examples{
data(advs)
assert_unit(advs, param = "WEIGHT", required_unit = "kg", get_unit_expr = VSSTRESU)
\dontrun{
assert_unit(advs, param = "WEIGHT", required_unit = "g", get_unit_expr = VSSTRESU)
}
}
\author{
Stefan Bundfuss
}
\keyword{assertion}
