% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_lstalvdt.R
\name{derive_var_lstalvdt}
\alias{derive_var_lstalvdt}
\title{Derive Last Known Alive Date}
\usage{
derive_var_lstalvdt(
  dataset,
  ...,
  source_datasets,
  subject_keys = vars(STUDYID, USUBJID)
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by \code{subject_keys} are required.}

\item{...}{Source(s) of known alive dates. One or more \code{lstalvdt_source()} objects are
expected.}

\item{source_datasets}{A named \code{list} containing datasets in which to search for the
last known alive date}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
The input dataset with the \code{LSTALVDT} variable added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

Add the last known alive date (\code{LSTALVDT}) to the dataset.
}
\details{
The following steps are performed to create the output dataset:

\enumerate{ \item For each source dataset the observations as specified by
the \code{filter} element are selected. Then for each patient the last
observation (with respect to \code{date}) is selected.

\item The \code{LSTALVDT} variable is set to the variable specified by the
\code{date} element. If the date variable is a datetime variable, only
the datepart is copied. If the source variable is a character variable, it
is converted to a date. If the date is incomplete, it is imputed as
specified by the \code{date_imputation} element.

\item The variables specified by the \code{traceability_vars} element are
added.

\item The selected observations of all source datasets are combined into a
single dataset.

\item For each patient the last observation (with respect to the \code{LSTALVDT}
variable) from the single dataset is selected and the new variable is
merged to the input dataset. }
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("dm")
data("ae")
data("lb")
data("adsl")

ae_start <- lstalvdt_source(
  dataset_name = "ae",
  date = AESTDTC,
  date_imputation = "first"
)
ae_end <- lstalvdt_source(
  dataset_name = "ae",
  date = AEENDTC,
  date_imputation = "first"
)
lb_date <- lstalvdt_source(
  dataset_name = "lb",
  date = LBDTC,
  filter = nchar(LBDTC) >= 10
)
adsl_date <- lstalvdt_source(dataset_name = "adsl", date = TRTEDT)

dm \%>\%
  derive_var_lstalvdt(
    ae_start, ae_end, lb_date, adsl_date,
    source_datasets = list(adsl = adsl, ae = ae, lb = lb)
  ) \%>\%
  select(USUBJID, LSTALVDT)

# derive last alive date and traceability variables
ae_start <- lstalvdt_source(
  dataset_name = "ae",
  date = AESTDTC,
  date_imputation = "first",
  traceability_vars = vars(
    LALVDOM = "AE",
    LALVSEQ = AESEQ,
    LALVVAR = "AESTDTC"
  )
)

ae_end <- lstalvdt_source(
  dataset_name = "ae",
  date = AEENDTC,
  date_imputation = "first",
  traceability_vars = vars(
    LALVDOM = "AE",
    LALVSEQ = AESEQ,
    LALVVAR = "AEENDTC"
  )
)
lb_date <- lstalvdt_source(
  dataset_name = "lb",
  date = LBDTC,
  filter = nchar(LBDTC) >= 10,
  traceability_vars = vars(
    LALVDOM = "LB",
    LALVSEQ = LBSEQ,
    LALVVAR = "LBDTC"
  )
)

adsl_date <- lstalvdt_source(
  dataset_name = "adsl",
  date = TRTEDT,
  traceability_vars = vars(
    LALVDOM = "ADSL",
    LALVSEQ = NA_integer_,
    LALVVAR = "TRTEDTM"
  )
)

dm \%>\%
  derive_var_lstalvdt(
    ae_start, ae_end, lb_date, adsl_date,
    source_datasets = list(adsl = adsl, ae = ae, lb = lb)
  ) \%>\%
  select(USUBJID, LSTALVDT, LALVDOM, LALVSEQ, LALVVAR)
}
\author{
Stefan Bundfuss, Thomas Neitmann
}
\keyword{adsl}
\keyword{derivation}
