% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_flag.R
\name{derive_worst_flag}
\alias{derive_worst_flag}
\title{Adds a Variable Flagging the Maximal / Minimal Value Within a Group of Observations}
\usage{
derive_worst_flag(
  dataset,
  by_vars,
  order,
  new_var,
  param_var,
  analysis_var,
  worst_high,
  worst_low,
  filter = NULL,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset.
Variables specified by \code{by_vars}, \code{order}, \code{param_var}, and \code{analysis_var} are expected.}

\item{by_vars}{Grouping variables

Permitted Values: list of variables}

\item{order}{Sort order.
Used to determine maximal / minimal observation if they are not unique,
see Details section for more information.}

\item{new_var}{Variable to add to the \code{dataset}.
It is set \code{"Y"} for the maximal / minimal observation of each group,
see Details section for more information.}

\item{param_var}{Variable with the parameter values for which the maximal / minimal
value is calculated.}

\item{analysis_var}{Variable with the measurement values for which the maximal / minimal
value is calculated.}

\item{worst_high}{Character with \code{param_var} values specifying the parameters
referring to "high".
Use \code{character(0)} if not required.}

\item{worst_low}{Character with \code{param_var} values specifying the parameters
referring to "low".
Use \code{character(0)} if not required.}

\item{filter}{Filter for flag data

Only observations fulfilling the specified condition are taken into account
for flagging. If the parameter is not specified, all observations are
considered.

Permitted Values: a condition}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

Default: \code{"warning"}

Permitted Values: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with the new flag variable added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{Deprecated}, please use \code{derive_var_worst_flag()} instead.
}
\details{
For each group with respect to the variables specified by the \code{by_vars} parameter,
the maximal / minimal observation of \code{analysis_var}
is labelled in the \code{new_var} column as \code{"Y"}
if its \code{param_var} is in \code{worst_high} / \code{worst_low},
otherwise it is assigned \code{NA}.
If there is more than one such maximal / minimal observation,
the first one with respect to the order specified by the \code{order} parameter is flagged.
}
\examples{

input <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~PARAMCD,  ~AVISIT,    ~ADT,                 ~AVAL,
  "TEST01", "PAT01",  "PARAM01", "BASELINE", as.Date("2021-04-27"), 15.0,
  "TEST01", "PAT01",  "PARAM01", "BASELINE", as.Date("2021-04-25"), 14.0,
  "TEST01", "PAT01",  "PARAM01", "BASELINE", as.Date("2021-04-23"), 15.0,
  "TEST01", "PAT01",  "PARAM01", "WEEK 1",   as.Date("2021-04-27"), 10.0,
  "TEST01", "PAT01",  "PARAM01", "WEEK 2",   as.Date("2021-04-30"), 12.0,

  "TEST01", "PAT02",  "PARAM01", "SCREENING",as.Date("2021-04-27"), 15.0,
  "TEST01", "PAT02",  "PARAM01", "BASELINE", as.Date("2021-04-25"), 14.0,
  "TEST01", "PAT02",  "PARAM01", "BASELINE", as.Date("2021-04-23"), 15.0,
  "TEST01", "PAT02",  "PARAM01", "WEEK 1",   as.Date("2021-04-27"), 10.0,
  "TEST01", "PAT02",  "PARAM01", "WEEK 2",   as.Date("2021-04-30"), 12.0,

  "TEST01", "PAT01",  "PARAM02", "SCREENING",as.Date("2021-04-27"), 15.0,
  "TEST01", "PAT01",  "PARAM02", "SCREENING",as.Date("2021-04-25"), 14.0,
  "TEST01", "PAT01",  "PARAM02", "SCREENING",as.Date("2021-04-23"), 15.0,
  "TEST01", "PAT01",  "PARAM02", "BASELINE", as.Date("2021-04-27"), 10.0,
  "TEST01", "PAT01",  "PARAM02", "WEEK 2",   as.Date("2021-04-30"), 12.0,

  "TEST01", "PAT02",  "PARAM02", "SCREENING",as.Date("2021-04-27"), 15.0,
  "TEST01", "PAT02",  "PARAM02", "BASELINE", as.Date("2021-04-25"), 14.0,
  "TEST01", "PAT02",  "PARAM02", "WEEK 1",   as.Date("2021-04-23"), 15.0,
  "TEST01", "PAT02",  "PARAM02", "WEEK 1",   as.Date("2021-04-27"), 10.0,
  "TEST01", "PAT02",  "PARAM02", "BASELINE", as.Date("2021-04-30"), 12.0,

  "TEST01", "PAT02",  "PARAM03", "SCREENING",as.Date("2021-04-27"), 15.0,
  "TEST01", "PAT02",  "PARAM03", "BASELINE", as.Date("2021-04-25"), 14.0,
  "TEST01", "PAT02",  "PARAM03", "WEEK 1",   as.Date("2021-04-23"), 15.0,
  "TEST01", "PAT02",  "PARAM03", "WEEK 1",   as.Date("2021-04-27"), 10.0,
  "TEST01", "PAT02",  "PARAM03", "BASELINE", as.Date("2021-04-30"), 12.0
)

derive_worst_flag(
  input,
  by_vars = vars(USUBJID, PARAMCD, AVISIT),
  order = vars(desc(ADT)),
  new_var = WORSTFL,
  param_var = PARAMCD,
  analysis_var = AVAL,
  worst_high = c("PARAM01", "PARAM03"),
  worst_low = "PARAM02"
)

\dontrun{
# example with ADVS
derive_worst_flag(
  advs,
  by_vars = vars(USUBJID, PARAMCD, AVISIT),
  order = vars(ADT, ATPTN),
  new_var = WORSTFL,
  param_var = PARAMCD,
  analysis_var = AVAL,
  worst_high = c("SYSBP", "DIABP"),
  worst_low = "RESP",
  filter = !is.na(AVISIT) & !is.na(AVAL)
)
}

}
\author{
Ondrej Slama
}
\keyword{adam}
\keyword{derivation}
