% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{get_many_to_one_dataset}
\alias{get_many_to_one_dataset}
\title{Get Many to One Values that Led to a Prior Error}
\usage{
get_many_to_one_dataset()
}
\value{
A \code{data.frame} or \code{NULL}
}
\description{
Get Many to One Values that Led to a Prior Error
}
\details{
If \code{assert_one_to_one()} detects an issue, the many to one values are stored
in a dataset. This dataset can be retrieved by \code{get_many_to_one_dataset()}.

Note that the function always returns the many to one values from the last
error that has been thrown in the current R session. Thus, after restarting
the R sessions \code{get_many_to_one_dataset()} will return \code{NULL} and after a
second error has been thrown, the dataset of the first error can no longer be
accessed (unless it has been saved in a variable).
}
\examples{
data(adsl)

try(
  assert_one_to_one(adsl, vars(SITEID), vars(STUDYID))
)

get_many_to_one_dataset()
}
\author{
Stefan Bundfuss
}
\keyword{user_utility}
