% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warnings.R
\name{suppress_warning}
\alias{suppress_warning}
\title{Suppress Specific Warnings}
\usage{
suppress_warning(expr, regexpr)
}
\arguments{
\item{expr}{Expression to be executed}

\item{regexpr}{Regular expression matching warnings to suppress}
}
\value{
Return value of the expression
}
\description{
Suppress certain warnings issued by an expression.
}
\details{
All warnings which are issued by the expression and match the regular expression
are suppressed.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(admiral_adsl)
data(admiral_vs)

# Remove label
attr(admiral_vs$USUBJID, "label") <- NULL

left_join(admiral_adsl, admiral_vs, by = "USUBJID")

suppress_warning(
  left_join(admiral_adsl, admiral_vs, by = "USUBJID"),
  "^Column `USUBJID` has different attributes on LHS and RHS of join$"
)
}
\author{
\itemize{
\item Thomas Neitmann
\item Stefan Bundfuss
}
}
\keyword{warning}
