% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_single_dose_dataset.R
\name{create_single_dose_dataset}
\alias{create_single_dose_dataset}
\title{Create dataset of single doses}
\usage{
create_single_dose_dataset(
  dataset,
  dose_freq = EXDOSFRQ,
  start_date = ASTDT,
  end_date = AENDT,
  lookup_table = dose_freq_lookup,
  lookup_column = CDISC_VALUE
)
}
\arguments{
\item{dataset}{Input dataset

The columns specified by \code{dose_freq}, \code{start_date} and the \code{end_date}
parameters are expected.}

\item{dose_freq}{The dose frequency

The aggregate dosing frequency used for multiple doses in a row.

Default: \code{EXDOSFRQ}

Permitted Values: defined by lookup table.}

\item{start_date}{The start date

A date or date-time object is expected. This object cannot contain \code{NA} values.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Default: \code{ASTDT}}

\item{end_date}{The end date

A date or date-time object is expected. This object cannot contain \code{NA} values.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Default: \code{AENDT}}

\item{lookup_table}{The dose frequency value lookup table

The table used to look up \code{dose_freq} values and determine the appropriate
multiplier to be used for row generation. If a lookup table other than the
default is used, it must have columns \code{DOSE_WINDOW}, \code{DOSE_COUNT}, and
\code{CONVERSION_FACTOR}. The default table \code{dose_freq_lookup} is described in
detail \link[=dose_freq_lookup]{here}.

Default: \code{dose_freq_lookup}

Permitted Values for \code{DOSE_WINDOW}: \code{"MINUTE"}, \code{"HOUR"}, \code{"DAY"},
\code{"WEEK"}, \code{"MONTH"}, \code{"YEAR"}}

\item{lookup_column}{The dose frequency value column in the lookup table

The column of \code{lookup_table}.

Default: \code{CDISC_VALUE} (column of \code{dose_freq_lookup})}
}
\value{
The input dataset with a single dose per row.
}
\description{
Derives dataset of single dose from aggregate dose information. This may be
necessary when e.g. calculating last dose before an adverse event in \code{ADAE}
or deriving a total dose parameter in \code{ADEX} when \code{EXDOSFRQ != ONCE}.
}
\details{
Each aggregate dose row is split into multiple rows which each
represent a single dose.The number of completed dose periods between
\code{start_date} and \code{end_date} is calculated with \code{compute_duration} and
multiplied by \code{DOSE_COUNT}. For \code{DOSE_WINDOW} values of \code{"WEEK"},
\code{"MONTH"}, and \code{"YEAR"}, \code{CONVERSION_FACTOR} is used to convert into days
the time object to be added to \code{start_date}.
}
\examples{
# Example with default lookup

library(lubridate)

data <- tibble::tribble(
  ~USUBJID, ~EXDOSFRQ, ~ASTDT, ~AENDT,
  "P01", "Q2D", ymd("2021-01-01"), ymd("2021-01-07"),
  "P01", "Q3D", ymd("2021-01-08"), ymd("2021-01-15"),
  "P01", "EVERY 2 WEEKS", ymd("2021-01-15"), ymd("2021-01-29")
)

create_single_dose_dataset(data)

# Example with custom lookup

custom_lookup <- tibble::tribble(
  ~Value, ~DOSE_COUNT, ~DOSE_WINDOW, ~CONVERSION_FACTOR,
  "Q30MIN", (1 / 30), "MINUTE", 1,
  "Q90MIN", (1 / 90), "MINUTE", 1
)

data <- tibble::tribble(
  ~USUBJID, ~EXDOSFRQ, ~ASTDTM, ~AENDTM,
  "P01", "Q30MIN", ymd_hms("2021-01-01T06:00:00"), ymd_hms("2021-01-01T07:00:00"),
  "P02", "Q90MIN", ymd_hms("2021-01-01T06:00:00"), ymd_hms("2021-01-01T09:00:00")
)

create_single_dose_dataset(data,
  lookup_table = custom_lookup,
  lookup_column = Value,
  start_date = ASTDTM,
  end_date = AENDTM
)
}
\author{
Michael Thorpe, Andrew Smith
}
\keyword{adae}
\keyword{adex}
\keyword{user_utility}
