% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_vars}
\alias{assert_vars}
\title{Is an Argument a List of Variables?}
\usage{
assert_vars(arg, optional = FALSE, expect_names = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}

\item{expect_names}{If the argument is set to \code{TRUE}, it is checked if all
variables are named, e.g., \code{vars(APERSDT = APxxSDT, APEREDT = APxxEDT)}.}
}
\value{
The function throws an error if \code{arg} is not a list of variables created using \code{vars()}
and returns the input invisibly otherwise.
}
\description{
Checks if an argument is a valid list of variables created using \code{vars()}
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(rlang)

example_fun <- function(by_vars) {
  assert_vars(by_vars)
}

example_fun(vars(USUBJID, PARAMCD))

try(example_fun(exprs(USUBJID, PARAMCD)))

try(example_fun(c("USUBJID", "PARAMCD", "VISIT")))

try(example_fun(vars(USUBJID, toupper(PARAMCD), desc(AVAL))))

example_fun_name <- function(by_vars) {
  assert_vars(by_vars, expect_names = TRUE)
}

example_fun_name(vars(APERSDT = APxxSDT, APEREDT = APxxEDT))

try(example_fun_name(vars(APERSDT = APxxSDT, APxxEDT)))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_varval_list}()}
}
\author{
Samia Kabi
}
\concept{assertion}
\keyword{assertion}
