% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warnings.R
\name{warn_if_vars_exist}
\alias{warn_if_vars_exist}
\title{Warn If a Variable Already Exists}
\usage{
warn_if_vars_exist(dataset, vars)
}
\arguments{
\item{dataset}{A \code{data.frame}

\describe{
\item{Default value}{none}
}}

\item{vars}{\code{character} vector of columns to check for in \code{dataset}

\describe{
\item{Default value}{none}
}}
}
\value{
No return value, called for side effects
}
\description{
Warn if a variable already exists inside a dataset
}
\examples{
library(dplyr, warn.conflicts = FALSE)
dm <- tribble(
  ~USUBJID,           ~ARM,
  "01-701-1015", "Placebo",
  "01-701-1016", "Placebo",
)

## No warning as `AAGE` doesn't exist in `dm`
warn_if_vars_exist(dm, "AAGE")

## Issues a warning
warn_if_vars_exist(dm, "ARM")
}
\seealso{
Function that provide users with custom warnings
\code{\link{suppress_warning}()},
\code{\link{warn_if_incomplete_dtc}()},
\code{\link{warn_if_inconsistent_list}()},
\code{\link{warn_if_invalid_dtc}()}
}
\concept{warnings}
\keyword{warnings}
