% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{ConstraintsCollection-class}
\alias{ConstraintsCollection-class}
\alias{ConstraintsCollection}
\title{Collection of constraints}
\arguments{
\item{s}{constraint collection}

\item{design}{design}
}
\description{
Collection of constraints
}
\section{Slots}{

\describe{
\item{\code{unconditional_constraints}}{a list of elements of class \code{UnconditionalConstraint}}

\item{\code{conditional_constraints}}{a list of elements of class \code{ConditionalConstraint}

A \code{ConstraintsCollection} is a collection of unconditional and
conditional constraints. In order to evaluate these correctly, they
have to be defined in two different slots.}
}}

\examples{
# Define Type one error rate
toer <- expected(ConditionalPower(Normal(), PointMassPrior(0.0, 1)))

# Define Power at delta = 0.4
pow <- expected(ConditionalPower(Normal(), PointMassPrior(0.4, 1)))

# Define expected sample size at delta = 0.4
ess <- expected(ConditionalSampleSize(Normal(), PointMassPrior(0.4, 1)))

# Compute design minimizing ess subject to power and toer constraints
\dontrun{
minimize(
   ess,
   subject_to(
      toer <= 0.025,
      pow  >= 0.9
   ),
   initial_design = TwoStageDesign(50, .0, 2.0, 60.0, 2.0, 5L)
)
}




}
\seealso{
A \code{ConstraintsCollection} can be created by \code{\link{subject_to}}.
}
