% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/PointMassPrior.R,
%   R/ContinuousPrior.R
\docType{methods}
\name{condition}
\alias{condition}
\alias{condition,PointMassPrior,numeric-method}
\alias{condition,ContinuousPrior,numeric-method}
\title{Condition a prior on an interval}
\usage{
condition(dist, interval, ...)

\S4method{condition}{PointMassPrior,numeric}(dist, interval, ...)

\S4method{condition}{ContinuousPrior,numeric}(dist, interval, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{interval}{length-two numeric vector giving the parameter interval to
condition on}

\item{...}{further optional arguments}
}
\value{
conditional \code{\link{Prior}} on given interval
}
\description{
Restrict an object of class \code{\link{Prior}} to a sub-interval and
re-normalize the PDF.
}
\examples{
tmp <- condition(PointMassPrior(c(0, .5), c(.3, .7)), c(-1, .25))
expectation(tmp, identity) # 0

tmp <- condition(
    ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4)),
    c(.3, .5)
)
bounds(tmp) # c(.3, .4)

}
