% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomialDistribution.R
\docType{class}
\name{Binomial-class}
\alias{Binomial-class}
\alias{Binomial}
\alias{quantile,Binomial-method}
\alias{simulate,Binomial,numeric-method}
\title{Binomial data distribution}
\usage{
Binomial(rate_control, two_armed = TRUE)

\S4method{quantile}{Binomial}(x, probs, n, theta, ...)

\S4method{simulate}{Binomial,numeric}(object, nsim, n, theta, seed = NULL, ...)
}
\arguments{
\item{rate_control}{assumed response rate in control group}

\item{two_armed}{logical indicating if a two-armed trial is regarded}

\item{x}{outcome}

\item{probs}{vector of probabilities}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}

\item{object}{object of class \code{Binomial}}

\item{nsim}{number of simulation runs}

\item{seed}{random seed}
}
\description{
Implements the normal approximation for a test on rates.
The reponse rate in the control group,
\ifelse{html}{\out{r<sub>C</sub>}}{\eqn{r_C}}, has to be specified by
\code{rate_control}.
The null hypothesis is:
\ifelse{html}{\out{r<sub>E</sub> &le; r<sub>C</sub>}}{\eqn{r_E <= r_C}},
where \ifelse{html}{\out{r<sub>E</sub>}}{\eqn{r_E}} denotes the response rate
in the invervention group.
It is tested against the alternative
\ifelse{html}{\out{r<sub>E</sub> > r<sub>C</sub>}}{\eqn{r_E > r_C}}.
The test statistic is given as
\ifelse{html}{\out{X<sub>1</sub> = &radic;n (r<sub>E</sub> - r<sub>C</sub>) / &radic;(2  r<sub>0</sub> (1-r<sub>0</sub>))}}{\eqn{X_1 = \sqrt{n}(r_E - r_C) / \sqrt{2 r_0 (1- r_0)}}},
where \ifelse{html}{\out{r<sub>0</sub>}}{\eqn{r_0}} denotes the mean between
\ifelse{html}{\out{r<sub>E</sub>}}{\eqn{r_E}} and
\ifelse{html}{\out{r<sub>C</sub>}}{\eqn{r_C}} in the two-armed case,
and \ifelse{html}{\out{r<sub>E</sub>}}{\eqn{r_E}} in the one-armed case.#'
All priors have to be defined for the rate difference
\ifelse{html}{\out{r<sub>E</sub> - r<sub>C</sub>}}{\eqn{r_E - r_C}}.
}
\details{
Note that \code{simulate} for class \code{Binomial} simulates the
   normal approximation of the test statistic.
}
\section{Slots}{

\describe{
\item{\code{rate_control}}{cf. parameter 'rate_control'}
}}

\examples{
datadist <- Binomial(rate_control = 0.2, two_armed = FALSE)

}
\seealso{
see \code{\link{probability_density_function}} and
   \code{\link{cumulative_distribution_function}} to evaluate the pdf
   and the cdf, respectively.
}
