% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R
\docType{class}
\name{TwoStageDesign-class}
\alias{TwoStageDesign-class}
\alias{TwoStageDesign}
\alias{TwoStageDesign,numeric-method}
\alias{summary,TwoStageDesign-method}
\title{Two-stage designs}
\usage{
TwoStageDesign(n1, ...)

\S4method{TwoStageDesign}{numeric}(
  n1,
  c1f,
  c1e,
  n2_pivots,
  c2_pivots,
  order = NULL,
  event_rate,
  ...
)

\S4method{summary}{TwoStageDesign}(object, ..., rounded = TRUE)
}
\arguments{
\item{n1}{stage-one sample size}

\item{...}{further optional arguments}

\item{c1f}{early futility stopping boundary}

\item{c1e}{early efficacy stopping boundary}

\item{n2_pivots}{numeric vector, stage-two sample size on the integration
pivot points}

\item{c2_pivots}{numeric vector, stage-two critical values on the integration
pivot points}

\item{order}{\code{integer}, integration order of the employed Gaussian quadrature
integration rule to evaluate scores. Automatically set to \code{length(n2_pivots)} if \cr
\code{length(n2_pivots) == length(c2_pivots) > 1}, otherwise c2 and n2
are taken to be constant in stage-two and replicated to match the number of
pivots specified by \code{order}}

\item{event_rate}{probability that a subject in either group will eventually have an event,
only needs to be specified for time-to-event endpoints}

\item{object}{object to show}

\item{rounded}{should rounded n-values be used?}
}
\description{
\code{TwoStageDesign} is the fundamental design class of the
\pkg{\link{adoptr}} package.
Formally, we represent a generic two-stage design as a five-tuple
\ifelse{html}{\out{(n<sub>1</sub>, c<sub>1</sub><sup>f</sup>, c<sub>1</sub><sup>e</sup>, n<sub>2</sub>(&middot;), c<sub>2</sub>(&middot;))}}{\eqn{\big(n_1, c_1^f, c_1^e, n_2(\cdot), c_2(\cdot)\big)}}.
Here, \ifelse{html}{\out{n<sub>1</sub>}}{\eqn{n_1}} is the first-stage sample
size (per group), \ifelse{html}{\out{c<sub>1</sub><sup>f</sup>}}{\eqn{c_1^f}}
and \ifelse{html}{\out{c<sub>1</sub><sup>e</sup>}}{\eqn{c_1^e}} are
boundaries for early stopping for futility and efficacy, respectively.
Since the trial design is a two-stage design, the elements
\ifelse{html}{\out{n<sub>2</sub>(&middot;)}}{\eqn{n_2(\cdot)}} (stage-two sample
size) and \ifelse{html}{\out{c<sub>2</sub>(&middot;)}}{\eqn{c_2(\cdot)}}
(stage-two critical value) are functions of the first-stage outcome
\ifelse{html}{\out{X<sub>1</sub>=x<sub>1</sub>}}{\eqn{X_1=x_1}}.
\ifelse{html}{\out{X<sub>1</sub>}}{\eqn{X_1}} denotes the first-stage test
statistic. A brief description on this definition of two-stage designs can be
read \href{https://optad.github.io/adoptr/articles/adoptr.html}{here}.
For available methods, see the 'See Also' section at the end of this page.
}
\details{
\code{summary} can be used to quickly compute and display basic facts about
a TwoStageDesign.
An arbitrary number of names \code{\link[=Scores]{UnconditionalScore}} objects can be
provided via the optional arguments \code{...} and are included in the summary displayed using
\code{\link{print}}.
}
\section{Slots}{

\describe{
\item{\code{n1}}{cf. parameter 'n1'}

\item{\code{c1f}}{cf. parameter 'c1f'}

\item{\code{c1e}}{cf. parameter 'c1e'}

\item{\code{n2_pivots}}{vector of length 'order' giving the values of n2 at the
pivot points of the numeric integration rule}

\item{\code{c2_pivots}}{vector of length order giving the values of c2 at the
pivot points of the numeric integration rule}

\item{\code{x1_norm_pivots}}{normalized pivots for integration rule (in [-1, 1])
the actual pivots are scaled to the interval [c1f, c1e] and can be
obtained by the internal method \cr
\code{adoptr:::scaled_integration_pivots(design)}}

\item{\code{weights}}{weights of of integration rule at \code{x1_norm_pivots} for
approximating integrals over \code{x1}}

\item{\code{tunable}}{named logical vector indicating whether corresponding slot is
considered a tunable parameter (i.e. whether it can be changed during
optimization via \code{\link{minimize}} or not; cf. \cr
\code{\link{make_fixed}})}
}}

\examples{
design <- TwoStageDesign(50, 0, 2, 50.0, 2.0, 5)
pow    <- Power(Normal(), PointMassPrior(.4, 1))
summary(design, "Power" = pow)

}
\seealso{
For accessing sample sizes and critical values safely, see methods in
\code{\link{n}} and \code{\link{c2}}; for modifying behaviour during optimizaton
see \code{\link{make_tunable}}; to convert between S4 class represenation and
numeric vector, see \code{\link{tunable_parameters}}; for simulating from a given
design, see \code{\link[=simulate,TwoStageDesign,numeric-method]{simulate}};
for plotting see \code{\link{plot,TwoStageDesign-method}}.
Both \link[=GroupSequentialDesign-class]{group-sequential} and
\link[=OneStageDesign]{one-stage designs} (!) are implemented as subclasses of
\code{TwoStageDesign}.
}
