% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompositeScore.R
\name{composite}
\alias{composite}
\alias{evaluate,CompositeScore,TwoStageDesign-method}
\title{Score Composition}
\usage{
composite(expr, label = NA_character_)

\S4method{evaluate}{CompositeScore,TwoStageDesign}(s, design, ...)
}
\arguments{
\item{expr}{Expression (in curly brackets); must contain at least one score
variable; if multiple scores are used, they must either all be conditional
or unconditional. Currently, no non-score variables are supported}

\item{label}{object label (string)}

\item{s}{object of class \code{CompositeScore}}

\item{design}{object}

\item{...}{further optional arguments}
}
\value{
an object of class \code{CompositeConditionalScore} or
\code{CompositeUnconditionalScore} depending on the class of the scores used
in \code{expr}
}
\description{
\code{composite} defines new composite scores by point-wise evaluation of
scores in any valid numerical expression.
}
\examples{
ess   <- ExpectedSampleSize(Normal(), PointMassPrior(.4, 1))
power <- Power(Normal(), PointMassPrior(.4, 1))

# linear combination:
composite({ess - 50*power})

# control flow (e.g. for and while loops)
composite({
  res <- 0
  for (i in 1:3) {
     res <- res + ess
  }
  res
})

# functional composition
composite({log(ess)})
cp <- ConditionalPower(Normal(), PointMassPrior(.4, 1))
composite({3*cp})

}
\seealso{
\link{Scores}
}
