% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_growth_rate.R
\name{fit_growth_rate}
\alias{fit_growth_rate}
\title{Fit a growth rate model to time series cases.}
\usage{
fit_growth_rate(
  cases,
  population = NULL,
  level = 0.95,
  family = c("quasipoisson", "poisson")
)
}
\arguments{
\item{cases}{An integer vector containing the time series cases.}

\item{population}{An integer vector containing the time series background population.}

\item{level}{The confidence level for parameter estimates, a numeric value between 0 and 1.}

\item{family}{A character string specifying the family for modeling. Choose between 'poisson', or 'quasipoisson'.
Must be one of: character, family-generator, or family object.}
}
\value{
A list containing:
\itemize{
\item 'fit': The fitted growth rate model.
\item 'estimate': A numeric vector with parameter estimates, including
the growth rate and its confidence interval.
\item 'level': The confidence level used for estimating parameter
confidence intervals.
}
}
\description{
This function fits a growth rate model to time series cases and provides parameter estimates along with
confidence intervals.
}
\examples{
# Fit a growth rate model to a time series of counts
# (e.g., population growth)
data <- c(100, 120, 150, 180, 220, 270)
fit_growth_rate(
  cases = data,
  level = 0.95,
  family = "poisson"
)
}
