% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_discrete_af.R
\name{scale_fill_discrete_af}
\alias{scale_fill_discrete_af}
\title{Discrete colour fill scales for Analysis Function plots}
\usage{
scale_fill_discrete_af(
  palette = "main",
  palette_type = c("af"),
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{Name of palette to use; e.g. "main", "sequential", "focus."
Default value is "main."}

\item{palette_type}{Currently only the Analysis Function palettes are
supported. Defaults to "af".}

\item{reverse}{Boolean value to indicate whether the palette should be
reversed.}

\item{...}{Additional arguments passed to scale type.}
}
\value{
ggplot2 discrete fill scale
}
\description{
Discrete colour fill scales for Analysis Function plots
}
\examples{
library(ggplot2)

d <- subset(mpg, manufacturer == "ford")

ggplot(d, aes(x = class, fill = class)) +
 geom_bar() +
 scale_fill_discrete_af()

}
