% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reaggregate_rates.R
\name{reaggregate_rates}
\alias{reaggregate_rates}
\alias{reaggregate_rates.default}
\title{Reaggregate age rates}
\usage{
reaggregate_rates(...)

\method{reaggregate_rates}{default}(
  bounds,
  rates,
  new_bounds,
  ...,
  population_bounds = NULL,
  population_weights = NULL
)
}
\arguments{
\item{...}{Further arguments passed to or from other methods.}

\item{bounds}{\verb{[numeric]}

The \emph{current} boundaries in (strictly) increasing order.

These correspond to the left hand side of the intervals (e.g. the
closed side of [x, y).

Double values are coerced to integer prior to categorisation.}

\item{rates}{\verb{[numeric]}

Vector of rates corresponding to the intervals defined by \code{bounds}.}

\item{new_bounds}{\verb{[numeric]}

The \emph{desired} boundaries in (strictly) increasing order.}

\item{population_bounds}{\verb{[numeric]}

Interval boundaries for a known population weighting given by the
\code{population_weights} argument.}

\item{population_weights}{\verb{[numeric]}

Population weightings corresponding to \code{population_bounds}.

Used to weight the output across the desired intervals.

If \code{NULL} (default) rates are divided proportional to the interval sizes.}
}
\value{
A data frame with 4 entries; \code{interval}, \code{lower_bound}, \code{upper_bound} and a
corresponding \code{rate}.
}
\description{
\code{reaggregate_rates()} converts rates over one interval range to another
with optional weighting by a known population.
}
\examples{

reaggregate_rates(
    bounds = c(0, 5, 10),
    rates = c(0.1, 0.2 ,0.3),
    new_bounds = c(0, 2, 7, 10),
    population_bounds = c(0, 2, 5, 7, 10),
    population_weights = c(100, 200, 50, 150, 100)
)

}
