% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart-functions.R
\name{estimate_rpart}
\alias{estimate_rpart}
\title{Estimation of rpart Objects}
\usage{
estimate_rpart(tree, y, D, X, method = "aipw", scores = NULL)
}
\arguments{
\item{tree}{An \code{\link[rpart]{rpart}} object.}

\item{y}{Outcome vector.}

\item{D}{Treatment assignment vector.}

\item{X}{Covariate matrix (no intercept).}

\item{method}{Either \code{"raw"} or \code{"aipw"}, controls how node predictions are replaced.}

\item{scores}{Optional, vector of scores to be used in replacing node predictions. Useful to save computational time if scores have already been estimated. Ignored if \code{method == "raw"}.}
}
\value{
A tree with node predictions replaced, as an \code{\link[rpart]{rpart}} object, and the scores (if \code{method == "raw"},
this is \code{NULL}).
}
\description{
Replace node predictions of an \code{\link[rpart]{rpart}} object using external data.
}
\details{
If \code{method == "raw"}, \code{estimate_rpart} replaces node predictions with the differences between the sample average
of the observed outcomes of treated units and the sample average of the observed outcomes of control units in each node,
which is an unbiased estimator of GATEs if the assignment to treatment is randomized.\cr

If \code{method == "aipw"}, \code{estimate_rpart} replaces node predictions with sample averages of doubly-robust
scores in each node. This is a valid estimator of GATEs in observational studies. Honest regression forests
and 5-fold cross fitting are used to estimate the propensity score and the conditional mean function of the outcome
(unless the user specifies the argument \code{scores}).\cr

\code{estimate_rpart} allows the user to implement "honest" estimation. If observations in \code{y}, \code{D} and \code{X}
have not been used to construct the \code{tree}, then the new predictions are honest in the sense of Athey and Imbens (2016).
To get standard errors for the tree's estimates, please use \code{\link{causal_ols_rpart}}.
}
\references{
\itemize{
  \item R Di Francesco (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{causal_ols_rpart}} \code{\link{avg_characteristics_rpart}}
}
\author{
Riccardo Di Francesco
}
