% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{make_moment_function}
\alias{make_moment_function}
\alias{make_moment_function.aghqmoment}
\alias{make_moment_function.aghqtrans}
\alias{make_moment_function.function}
\alias{make_moment_function.character}
\alias{make_moment_function.list}
\alias{make_moment_function.default}
\title{Moments of Positive Functions}
\usage{
make_moment_function(...)

\method{make_moment_function}{aghqmoment}(gg, ...)

\method{make_moment_function}{aghqtrans}(gg, ...)

\method{make_moment_function}{`function`}(gg, ...)

\method{make_moment_function}{character}(gg, ...)

\method{make_moment_function}{list}(gg, ...)

\method{make_moment_function}{default}(gg, ...)
}
\arguments{
\item{...}{Used to pass arguments to methods.}

\item{gg}{LOGARITHM of function \verb{R^p -> R^+} of which the moment is to be computed along with its two derivatives. So for example providing gg = function(x) x will compute the moment of exp(x).
Provided either as a \code{function}, a \code{list}, an \code{aghqtrans} object, or an \code{aghqmoment} object. See details.}
}
\value{
Object of class \code{aghqmoment}, which is a list with elements \code{fn},
\code{gr}, and \code{he}, exactly like the input to \code{aghq::aghq()} and related functions. Here \code{gg$fn} is
\code{log(gg(theta))}, \code{gg$gr} is its gradient, and \code{gg$he} its Hessian.
Object is suitable for checking with \code{aghq::validate_moment()}
and for inputting into \code{aghq::compute_moment()}.
}
\description{
Given an object \code{quad} of class \code{aghq} returned by \code{aghq::aghq()}, \code{aghq::compute_moment()}
will compute the moment of a positive function \code{g(theta)} of parameter \code{theta}. The present function,
\code{aghq::make_moment_function()}, assists the user in constructing the appropriate input to \code{aghq::compute_moment()}.
}
\details{
The approximation of moments of positive functions implemented in \code{aghq::compute_moment()}
achieves the same asymptotic rate of convergence as the marginal likelihood. This involves computing a new mode and
Hessian depending on the original posterior mode and Hessian, and \code{g}. These computations are handled by \code{aghq::compute_moment()},
re-using information from the original quadrature when feasible.

Computation of moments is defined only for scalar-valued functions, with a vector moment just defined as a vector of moments. Consequently,
the user may input to \code{aghq:compute_moment()} a function \code{g: R^p -> R^q+} for any \code{q}, and that function will return the corresponding
vector of moments. This is handled within \code{aghq::compute_moment()}. The \code{aghq::make_moment_function()} interface accepts the logarithm of \code{gg: R^p -> R^+}, i.e.
a multivariable, scalar-valued positive function. This is mostly to keep first and second derivatives as 1d and 2d arrays (i.e. the gradient and the Hessian);
I deemed it too confusing for the user and the code-base to work with Jacobians and 2nd derivative tensors (if you're confused just reading this, there you go!).
But, see \code{aghq::compute_moment()} for how to handle the very common case where the \emph{same} transformation is desired of all parameter coordinates; for example
when all parameters are on the log-scale and you want to compute \code{E(exp(theta))} for \emph{vector} \code{theta}.

If \code{gg} is a \code{function} or a \code{character} (like \code{'exp'}) it is first passed to \code{match.fun}, and then the output
object is constructed using \code{numDeriv::grad()} and \code{numDeriv::hessian()}. If \code{gg} is a \code{list} then it is assumed to
have elements \code{fn}, \code{gr}, and \code{he} of the correct form, and these elements are extracted and then passed back to \code{make_moment_function()}.
If \code{gg} is an object of class \code{aghqtrans} returned by \code{aghq::make_transformation()}, then \code{gg$fromtheta}
is passed back to \code{make_moment_function()}. If \code{gg} is an object of class \code{aghqtrans} then it is just returned.
}
\examples{
# E(exp(x))
mom1 <- make_moment_function(force) # force = function(x) x
mom2 <- make_moment_function('force')
mom3 <- make_moment_function(list(fn=function(x) x,gr=function(x) 1,he = function(x) 0))

}
\seealso{
Other moments: 
\code{\link{validate_moment}()}
}
\concept{moments}
