% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_design_crd}
\alias{plot_design_crd}
\title{#' Plot Completely Randomized Design}
\usage{
plot_design_crd(
  design,
  ncols,
  nrows,
  y = "row",
  factor_name = "trt",
  labels = "plots",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{ncols}{integer value, choose the number of columns to which the experiment should be plotted}

\item{nrows}{integer value, choose the number of rows to which the experiment should be plotted}

\item{y}{Describes the y coordinates of a experiment design, default is row}

\item{factor_name}{Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{labels}{Describes the column from that the plots are taken to display them}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of a factorial experiment with randomized complete block design from \code{agricolae} design.ab
}
\examples{
library(agricolaeplotr)
library(agricolae)
trt = c(2,3,4,5,6)
outdesign1 <-design.crd(trt,r=5,serie=2,2543,'Mersenne-Twister')
plot_design_crd(outdesign1,ncols = 13,nrows = 3)
}
