% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{summary}
\alias{summary}
\title{summary of a field Layout}
\usage{
summary(object, unit = "m", part = "net_plot", ...)
}
\arguments{
\item{object}{an object, created by DOE_obj with a FieldLayout class}

\item{unit}{a string that corresponds to measure unit (default is m)}

\item{part}{which part of the summary are you interested?
Choose one of the following: "net_plot","gross_plot","field","experiment","all"}

\item{...}{further arguments passed to or from other methods}
}
\description{
print a summary of a FieldLayout object
}
\examples{
library(agricolaeplotr)
library(agricolae)
varieties<-c('perricholi','yungay','maria bonita','tomasa')
outdesign <-design.youden(varieties,r=2,serie=2,seed=23)
p <- plot_youden(outdesign, labels = 'varieties')
stats <- DOE_obj(p)
# print plot summary for net plot (plots without space)
summary(stats, part = "net_plot")
# print plot summary for gross plot (plots with space)
summary(stats, part = "gross_plot")
# print plot summary for entire field
summary(stats, part = "field")
# print plot summary for design summary
summary(stats, part = "experiment")
# print plot summary for all information shown above in one output
summary(stats, part = "all")
}
