% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstTemp.R
\name{firstTemp}
\alias{firstTemp}
\title{Mean first day with a temperature over a threshold}
\usage{
firstTemp(
  mx,
  dates,
  iniday = "01-01",
  endday = "09-01",
  type = "doy",
  thres = 35
)
}
\arguments{
\item{mx}{vector of daily (usually maximum) temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{iniday}{first day of the year ("dd-mm") when frost occurrence will be considered.}

\item{endday}{last day of the year ("dd-mm") when frost occurrence will be considered.}

\item{type}{type of output. It can be "doy" for day of the year (julian day) or "date" for data format ("dd-mm").}

\item{thres}{temperature threshold considered to trigger occurrence (+35 by default).}
}
\value{
Depending on argument type, the output will be a numeric vector of julian days (type = "doy") or a vector of characters with dates (type = "date").
}
\description{
Calculates the first day, within a predefined period, with a temperature over a threshold
}
\details{
The function is able to span over years. If the argument "enddate" is a date earlier than "inidate", the considered period will cover from "inidate" to the end of the year and from the beginning of the next year to "enddate".
}
\examples{


firstTemp(mx = daily_tmax,
            dates = seq.Date(as.Date('1981-01-01'),
                             as.Date('2010-12-31'), by ='day'),
            iniday = '01-01',
            endday = '01-09',
            type = 'doy',
            thres = 35)
}
