% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_mat.R
\name{ahp.mat}
\alias{ahp.mat}
\title{Generate AHP pairwise matrices from survey data}
\usage{
ahp.mat(df, atts, negconvert = FALSE, reciprocal = TRUE)
}
\arguments{
\item{df}{a dataframe, each row corresponding to one decision-maker, with columns ordered according to  \code{atts}.}

\item{atts}{a list of attributes in the correct order}

\item{negconvert}{logical, whether to convert all positive values to
negative. In the pairwise comparison A_B, if -6 denotes A is more
important than B by 6 units, set \code{negconvert = TRUE}.}

\item{reciprocal}{logical, whether to convert negative values (after \code{negconvert}) to its reciprocal. If the comparison A_B where B is more important than A was already entered in its reciprocal (e.g. 1/6), choose \code{reciprocal = FALSE}. When \code{reciprocal = FALSE}, do not set \code{negconvert = TRUE}.}
}
\value{
A list of pairwise comparison matrices of each decision-maker.
}
\description{
\code{ahp.mat} takes in paired comparisons from survey data with questions using the
analytic hierarchy process and converts it into pairwise comparison matrices
for each individual decision-maker. Examples based on \insertCite{Saaty2004;textual}{ahpsurvey}.
}
\examples{


data(city200)
atts <- c('cult', 'fam', 'house', 'jobs', 'trans')
ahp.mat(df = city200, atts = atts, negconvert = TRUE)

}
\references{
\insertRef{Saaty2004}{ahpsurvey}
}
\author{
Frankie Cho
}
