% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aibd.R
\name{aibd}
\alias{aibd}
\title{Define an Attraction Indian Buffet Distribution (AIBD) for Feature Allocations}
\usage{
aibd(
  mass,
  permutation,
  temperature,
  distance,
  decayFunction = c("exponential", "reciprocal", "identity")[1]
)
}
\arguments{
\item{mass}{The mass (a.k.a., concentration) parameter of the AIBD.}

\item{permutation}{A permutation, i.e., a vector of integers \code{1, 2, ...,
n} whose length is \code{n} and whose elements are unique.  Using the Indian
buffet analogy, the permutation represents the order the customers enter the buffet.}

\item{temperature}{A nonnegative scalar which determines how influential the
distance matrix is in the feature allocation distribution.  The AIBD reduces to
the IBP when the temperature is zero and diverges from the IBP as the temperature increases.}

\item{distance}{A distance matrix, i.e., a symmetric matrix whose
\code{(i,j)} entry is small if items \code{i} and \code{j} are similar.  An object
of class \code{"dist"} is also permissible.}

\item{decayFunction}{One of the following strings: \code{"exponential"}
(making \code{similarity = exp(-temperature*distance)}),
\code{"reciprocal"} (making \code{similarity = 1/distance^temperature}), or
\code{"identity"} (in which case \code{distance} is interpreted as a
similarity instead of a distance).}
}
\value{
An object representing an Attraction Indian Buffet Distribution
  (AIBD) for feature allocations.
}
\description{
This function specifies an Attraction Indian Buffet Distribution (AIBD), which is a
distribution over feature allocations.
}
\examples{
\donttest{ # Regardless of size, the initial warmup can exceed CRAN's 5 seconds threshold
states <- c("California","Wisconsin","Nebraska","New York")
data <- USArrests[states,]
dist <- dist(scale(data))
aibd(1, seq_along(states), 1.0, dist)

\dontshow{
rscala::scalaDisconnect(aibd:::s)
}
}

}
