% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_sequential_analysis.R
\name{DoSA}
\alias{DoSA}
\title{Sequential analysis.}
\usage{
DoSA(
  data = NULL,
  source = NULL,
  time = NULL,
  n = NULL,
  es = NULL,
  se = NULL,
  r1 = NULL,
  m1 = NULL,
  sd1 = NULL,
  n1 = NULL,
  r2 = NULL,
  m2 = NULL,
  sd2 = NULL,
  n2 = NULL,
  group = c("Group 1", "Group 2"),
  ref = 2,
  prefer = "small",
  measure = "ES",
  model = "random",
  method = "DL",
  pooling = "IV",
  alpha = 0.05,
  beta = 0.2,
  PES = "post-hoc",
  PV = "post-hoc",
  adjust = "none",
  plot = FALSE,
  id = FALSE,
  invert = FALSE,
  BSB = FALSE
)
}
\arguments{
\item{data}{DATAFRAME consists of relevant information.}

\item{source}{CHARACTER for labeling the included data sets.}

\item{time}{NUMERIC values of time sequence.}

\item{n}{INTEGER values of sample sizes.}

\item{es}{NUMERIC values of effect sizes.}

\item{se}{NUMERIC values of standard errors for the effect sizes.}

\item{r1}{INTEGER values of observed events in group 1 in the included data.}

\item{m1}{NUMERIC values of estimated means in group 1 in the included data.}

\item{sd1}{NUMERIC values of standard deviations in group 1 in the
included data.}

\item{n1}{INTEGER values of sample sizes in group 1 in the included data.}

\item{r2}{INTEGER values of observed events in group 2 in the included data.}

\item{m2}{NUMERIC values of estimated means in group 2 in the included data.}

\item{sd2}{NUMERIC values of standard deviations in group 2 in the
included data.}

\item{n2}{INTEGER values of sample sizes in group 2 in the included data.}

\item{group}{CHARACTER for labeling two groups.}

\item{ref}{NUMERIC values of 1 or 2 for indicating group 1 or 2 as reference.}

\item{prefer}{CHARACTER of "small" and "large" for indicating which direction
is beneficial effect in statistic test.}

\item{measure}{CHARACTER for indicating which statistic measure should be used.}

\item{model}{CHARACTER of "random" and "fixed" for indicating whether
to use random-effects model or fixed-effect model.}

\item{method}{CHARACTER for indicating which estimator should be used in
random-effects model. In addition to the default "DL" method,
the current version also supports "REML" and "PM" methods for
calculating heterogeneity estimator.}

\item{pooling}{CHARACTER for indicating which method has to be used for pooling
binary data. Current version consists of "IV" and "MH" for
binary data pooling.}

\item{alpha}{NUMERIC value between 0 to 1 for indicating the assumed type I
error.}

\item{beta}{NUMERIC value between 0 to 1 for indicating the assumed type II
error.}

\item{PES}{NUMERIC value for indicating the presumed meaningful effect size.}

\item{PV}{NUMERIC value for indicating the presumed variance of the
meaningful effect size.}

\item{adjust}{CHARACTER for indicating how to adjust expected information size.
Current version consists of "none" and "D2" for the adjustment.}

\item{plot}{LOGIC value for indicating whether to illustrate alpha-spending
monitoring plot.}

\item{id}{LOGIC value for indicating whether to label each data source.}

\item{invert}{LOGIC value for indicating whether to invert plot.}

\item{BSB}{LOGIC value for indicating whether to illustrate beta-spending
boundaries.}
}
\value{
\strong{DoSA()} returns a summary on the result of sequential analysis.
\item{studies}{Numbers of studies included in the sequential analysis.}
\item{AIS}{Acquired information size refers to the total sample size in the
sequential analysis.}
\item{alpha}{A numeric value of type I error for the sequential analysis.}
\item{beta}{A numeric value of type II error for the sequential analysis.}
\item{PES}{A numeric value of presumed meaningful effect size for the
sequential analysis.}
\item{Varian}{A numeric value of presumed variance of the meaningful effect
size for the sequential analysis.}
\item{Divers}{A numeric value to show diversity in the pooled analysis.}
\item{AF}{A numeric value of adjustment factor.}
\item{RIS.org}{A numeric value for required information size without adjustment.}
\item{RIS.adj}{A numeric value for adjusted required information size.}
\item{frag}{A vector of fraction of each study included in the sequential
analysis.}
\item{weight}{A vector of weight of each study included in the sequential
analysis.}
\item{es.cum}{A vector of cumulative effect size in the sequential analysis.}
\item{se.cum}{A vector of standard error for the cumulative effect size in the
sequential analysis.}
\item{zval.cum}{A vector of cumulative z-value in the sequential analysis.}
\item{asb}{A data frame of alpha-spending values for each study.}
\item{aslb}{A numeric value for lower alpha-spending boundary.}
\item{asub}{A numeric value for upper alpha-spending boundary.}
}
\description{
\strong{DoSA()} is a function for conducting sequential analysis.
}
\examples{
## Not run:
# 1. Import a dataset of study by Fleiss (1993)
library(meta)
data("Fleiss1993cont")

# 2. Perform sequential analysis
 output <- DoSA(Fleiss1993cont, study, year,
                m1 = mean.psyc, sd1 = sd.psyc, n1 = n.psyc,
                m2 = mean.cont, sd2 = sd.cont, n2 = n.cont,
                measure = "SMD", PES = 0.5,
                group = c("Psychotherapy", "Control"), plot = TRUE)

## End(Not run)

}
\references{
Jennison, C., & Turnbull, B. W. (2005). Meta-analyses and adaptive group
sequential designs in the clinical development process.
\strong{Journal of biopharmaceutical statistics}, \emph{15(4)}, 537–558.
https://doi.org/10.1081/BIP-200062273.

Wetterslev, J., Jakobsen, J. C., & Gluud, C. (2017). Trial sequential analysis
in systematic reviews with meta-analysis. \strong{BMC medical research methodology},
\emph{17(1)}, 1-18.

NCSS Statistical Software (2023). \strong{Group-sequential analysis for two proportions}.
In \emph{PASS Documentation}. Available online:
https://www.ncss.com/wp-content/themes/ncss/pdf/Procedures/NCSS/Group-Sequential_Analysis_for_Two_Proportions.pdf
}
\seealso{
\code{\link{TestDisparity}}, \code{\link{TestDiscordance}}
}
\author{
Enoch Kang
}
