% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIFETransformerMaker.R
\docType{data}
\name{aife_transformer_maker}
\alias{aife_transformer_maker}
\title{\code{R6} object of the \code{AIFETransformerMaker} class}
\format{
An object of class \code{AIFETransformerMaker} (inherits from \code{R6}) of length 3.
}
\usage{
aife_transformer_maker
}
\description{
Object for creating the transformers with different types. See \link{AIFETransformerMaker} class for
details.
}
\examples{
# Use 'make' method of the 'aifeducation::aife_transformer_maker' object
# Pass string with the type of transformers
# Allowed types are "bert", "deberta_v2", "funnel", etc. See aifeducation::AIFETrType list
my_bert <- aife_transformer_maker$make("bert")

# Or use elements of the 'aifeducation::AIFETrType' list
my_longformer <- aife_transformer_maker$make(AIFETrType$longformer)

# Run 'create' or 'train' methods of the transformer in order to create a
# new transformer or train the newly created one, respectively
# my_bert$create(...)
# my_bert$train(...)

# my_longformer$create(...)
# my_longformer$train(...)

}
\seealso{
Other Transformer: 
\code{\link{AIFETrType}},
\code{\link{AIFETransformerMaker}}
}
\concept{Transformer}
\keyword{datasets}
