% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateInputsCrit.GRiwrmInputsModel.R,
%   R/CreateInputsCrit.InputsModel.R, R/CreateInputsCrit.R
\name{CreateInputsCrit.GRiwrmInputsModel}
\alias{CreateInputsCrit.GRiwrmInputsModel}
\alias{CreateInputsCrit.InputsModel}
\alias{CreateInputsCrit}
\title{Creation of the InputsCrit object required to the \code{ErrorCrit} functions}
\usage{
\method{CreateInputsCrit}{GRiwrmInputsModel}(
  InputsModel,
  FUN_CRIT = ErrorCrit_NSE,
  RunOptions,
  Obs,
  AprioriIds = NULL,
  k = 0.15,
  AprCelerity = 1,
  ...
)

\method{CreateInputsCrit}{InputsModel}(InputsModel, FUN_CRIT, ...)

CreateInputsCrit(InputsModel, ...)
}
\arguments{
\item{InputsModel}{object of class \emph{InputsModel} or \emph{GRiwrmInputsModel}. See \link{CreateInputsModel}}

\item{FUN_CRIT}{[function (atomic or list)] error criterion function (e.g. \link[airGR:ErrorCrit_RMSE]{airGR::ErrorCrit_RMSE}, \link[airGR:ErrorCrit_NSE]{airGR::ErrorCrit_NSE})}

\item{RunOptions}{object of class \emph{RunOptions} or \emph{GRiwrmRunOptions}, see \link{CreateRunOptions}}

\item{Obs}{\link{numeric}, \link{matrix} or \link{data.frame} series of observed flows, see details}

\item{AprioriIds}{(optional) named \link{list} or named \link{vector} of \link{character} used for the parameter regularization (see details)}

\item{k}{(optional) \link{numeric} weight coefficient used in the parameter regularization (See \link[airGR:CreateInputsCrit_Lavenne]{airGR::CreateInputsCrit_Lavenne})}

\item{AprCelerity}{(optional) \link{numeric} Default celerity used as a priori parameter for upstream catchments}

\item{...}{arguments passed to \link[airGR:CreateInputsCrit]{airGR::CreateInputsCrit}, see details}
}
\value{
Depending on the class of \code{InputsModel} argument (respectively \code{InputsModel} and \code{GRiwrmInputsModel} object), the returned value is respectively:
\itemize{
\item a \code{InputsCrit} object (See \link[airGR:CreateInputsCrit]{airGR::CreateInputsCrit})
\item a \code{GRiwrmInputsCrit} object which is a \link{list} of \code{InputsCrit} objects with one item per modeled sub-catchment
}
}
\description{
This function can be used either for a catchment (with an \emph{InputsModel} object) or for a network (with a \emph{GRiwrmInputsModel} object)
}
\details{
See \link[airGR:CreateInputsCrit]{airGR::CreateInputsCrit} documentation for a complete list of arguments.

\code{Obs} argument is equivalent to the same argument in \link[airGR:CreateInputsCrit]{airGR::CreateInputsCrit} except that it must be a \link{matrix} or a \link{data.frame} if \code{InputsModel} is a \emph{GRiwrmInputsModel} object.
Then, each column of the \link{matrix} or \link{data.frame} represents the observations of one of the simulated node with the name of the columns representing the id of each node.

With a \emph{GRiwrmInputsModel} object, all arguments are applied on each sub-catchments of the network.

Parameter regularization consists of defining a priori parameters which are used in a composed criterion based on the formula proposed by Lavenne et al. (2019) (See \link[airGR:CreateInputsCrit_Lavenne]{airGR::CreateInputsCrit_Lavenne}).
The parameter \code{AprioriIds} allows to define which upstream sub-catchment is used for providing a priori parameters. Its format is as follows: \code{AprioriIds <- c("Downstream sub-catchment 1" = "A priori upstream sub-catchment 1", ...)} where the quoted strings are the ids of the sub-catchments. See vignettes for more details. The parameter \code{AprCelerity} is a default value used as a priori for the parameter 'Celerity' in case of an upstream catchment (without celerity parameter) is used as a priori catchment.
}
\references{
De Lavenne, A., Andréassian, V., Thirel, G., Ramos, M.-H., Perrin, C., 2019. A Regularization Approach to Improve the Sequential Calibration of a Semidistributed Hydrological Model. Water Resources Research 55, 8821–8839. \doi{10.1029/2018WR024266}
}
