% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Qm3s.R
\name{plot.Qm3s}
\alias{plot.Qm3s}
\title{Plot of a \code{Qm3s} object (time series of simulated flows)}
\usage{
\method{plot}{Qm3s}(
  x,
  type = "l",
  xlab = "Date",
  ylab = expression("Flow (m"^"3" * "/s)"),
  main = "Simulated flows",
  col = rainbow(ncol(x) - 1),
  legend = colnames(x)[-1],
  legend.cex = 0.7,
  legend.x = "topright",
  legend.y = NULL,
  lty = 1,
  ...
)
}
\arguments{
\item{x}{\link{data.frame} with a first column with \link{POSIXt} dates and followings columns with flows at each node of the network}

\item{type}{\link{character} plot type (See \link{plot.default}), default "l"}

\item{xlab}{\link{character} label for the x axis, default to "Date"}

\item{ylab}{\link{character} label for the y axis, default to "Flow (m3/s)"}

\item{main}{\link{character} main title for the plot, default to "Simulated flows"}

\item{col}{\link{character} plotting color (See \link{par}), default to rainbow colors}

\item{legend}{\link{character} see parameter \code{legend} of \link{legend}. Set to \link{NULL} if display of the legend is not wanted}

\item{legend.cex}{\link{character} \code{cex} parameter for the text of the legend (See \link{par})}

\item{legend.x, legend.y}{Legend position, see \code{x} and \code{y} parameters in \link[graphics:legend]{graphics::legend}}

\item{lty}{\link{character} or \link{numeric} The line type (See \link{par})}

\item{...}{Further arguments to pass to the \link{matplot} functions}
}
\value{
Screen plot window.
}
\description{
Plot of a \code{Qm3s} object (time series of simulated flows)
}
